/*
 * Decompiled with CFR 0.152.
 */
package org.grade.repo.utils;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.grade.common.annotation.Qualifiers;
import org.grade.common.events.ApplicationEvent;
import org.grade.repo.Endpoint;
import org.grade.repo.GenericRepository;

@ApplicationScoped
public class RepositoryUtils {
    private static GenericRepository staging;
    private static GenericRepository production;
    private static String param_format;
    private static Pattern endpoint_regexp;

    public static void configure(@Observes ApplicationEvent.Startup event, @Qualifiers.Staging GenericRepository r1, @Qualifiers.Production GenericRepository r2) {
        staging = r1;
        production = r2;
    }

    public static Endpoint resolve(String name) {
        Optional<Endpoint> ep = production.endpoints().resolveIfExists(name);
        if (!ep.isPresent()) {
            ep = staging.endpoints().resolveIfExists(name);
        }
        if (ep.isPresent()) {
            return ep.get();
        }
        throw new IllegalStateException("unknown endpoint " + name);
    }

    public static Query parse(String query) {
        return RepositoryUtils.parse(query, Collections.emptyMap());
    }

    public static Query parse(String query, Map<String, String> args) {
        String instance = query;
        for (Map.Entry<String, String> e : args.entrySet()) {
            String regexp = String.format(param_format, e.getKey());
            if (!instance.contains(regexp)) continue;
            instance = instance.replaceAll(regexp, e.getValue());
        }
        Matcher m = endpoint_regexp.matcher(instance);
        while (m.find()) {
            instance = instance.replace(m.group(1), String.format("<%s>", RepositoryUtils.resolve(m.group(2)).configuration().uri()));
        }
        Query parsed = QueryFactory.create((String)instance);
        if (args.containsKey("grade_limit")) {
            try {
                parsed.setLimit((long)Math.min(Integer.valueOf(args.get("grade_limit")), Integer.valueOf("300")));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("invalid value " + args.get("grade_limit") + " for parameter " + "grade_limit");
            }
        }
        return parsed;
    }

    static {
        param_format = "!%s";
        endpoint_regexp = Pattern.compile("service\\s+(\\[(.+?)\\])", 2);
    }
}

