/*
 * Decompiled with CFR 0.152.
 */
package org.grade.repo;

import javax.inject.Inject;
import org.grade.common.GradeUtils;
import org.grade.configuration.GraphConfiguration;
import org.grade.repo.Endpoint;
import org.grade.repo.Query;
import org.grade.repo.RdfRepository;
import org.grade.repo.Task;
import org.grade.repo.impl.AbstractRepositoryDelegate;

public class TaskRepository
extends AbstractRepositoryDelegate<Task> {
    final Endpoint base;

    @Inject
    public TaskRepository(RdfRepository repo) {
        super(repo, Task::new);
        Query tasks = this.queries().resolve("all_tasks");
        this.base = this.endpoints().resolve(tasks.endpoint());
    }

    public Task lookup(String uri) {
        try {
            return new Task(this.repo.lookup(uri, this.base));
        }
        catch (Exception e) {
            throw GradeUtils.unchecked((String)("cannot lookup task '" + uri + "'"), (Throwable)e);
        }
    }

    public void save(Task task) {
        try {
            if (task.uri() == null || task.uri().isEmpty()) {
                task.generateUri();
            }
            task.validate();
            GraphConfiguration graph = GraphConfiguration.graph((String)task.graphUri()).label(task.label());
            this.repo.update(graph, task.resource(), this.base);
        }
        catch (Exception e) {
            GradeUtils.rethrowUnchecked((String)("cannot save task '" + task.uri() + "'"), (Throwable)e);
        }
    }

    public void remove(String uri) {
        try {
            this.repo.delete(Task.toGraphUri(uri), this.base);
        }
        catch (Exception e) {
            GradeUtils.rethrowUnchecked((String)("cannot delete task '" + uri + "'"), (Throwable)e);
        }
    }
}

