/*
 * Decompiled with CFR 0.152.
 */
package org.grade.repo;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.modify.request.UpdateDrop;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateRequest;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.grade.common.annotation.Qualifiers;
import org.grade.configuration.GraphConfiguration;
import org.grade.configuration.QueryConfiguration;
import org.grade.configuration.RepositoryConfiguration;
import org.grade.repo.Endpoint;
import org.grade.repo.Endpoints;
import org.grade.repo.Queries;
import org.grade.repo.Query;
import org.grade.repo.Repository;
import org.grade.repo.impl.memory.MemoryEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfRepository
implements Repository<Resource> {
    private static final Logger log = LoggerFactory.getLogger(RdfRepository.class);
    private static Resource root = ModelFactory.createDefaultModel().createResource("http://data.gradesystem.eu/onto#root");
    private final Endpoints endpoints;
    private final Queries queries;

    public RdfRepository(RepositoryConfiguration cfg, @Qualifiers.Production Iterable<MemoryEndpoint> predefined) {
        this.endpoints = new Endpoints(cfg.endpoints(), predefined);
        this.queries = new Queries(cfg.queries(), cfg.endpoints());
    }

    @Override
    public Endpoints endpoints() {
        return this.endpoints;
    }

    @Override
    public Queries queries() {
        return this.queries;
    }

    @Override
    public List<Resource> get(String key, Map<String, String> args) {
        Query query = this.queries.resolve(key);
        Model model = (Model)this.$execute(query, args);
        ResIterator resources = model.listResourcesWithProperty(RDF.type, (RDFNode)root);
        return resources.toList();
    }

    @Override
    public List<Resource> get(QueryConfiguration config, Map<String, String> args) {
        Model model = (Model)this.$execute(Query.queryWith(config), args);
        ResIterator resources = model.listResourcesWithProperty(RDF.type, (RDFNode)root);
        return resources.toList();
    }

    @Override
    public <T> T execute(QueryConfiguration config, Map<String, String> args) {
        return this.$execute(Query.queryWith(config), args);
    }

    @Override
    public <T> T execute(String key, Map<String, String> args) {
        return this.$execute(this.queries.resolve(key), args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource lookup(String uri, Endpoint ep) {
        QueryExecution exec = ep.executionFor(QueryFactory.create((String)String.format("describe <%s>", uri)));
        try {
            Model model = exec.execDescribe();
            if (model.isEmpty()) {
                throw new IllegalArgumentException("no such resource: " + uri);
            }
            Resource resource = model.getResource(uri);
            return resource;
        }
        finally {
            if (Collections.singletonList(exec).get(0) != null) {
                exec.close();
            }
        }
    }

    public void update(GraphConfiguration graph, Resource resource, Endpoint ep) {
        ep.create(graph, resource.getModel());
    }

    public void delete(String graphUri, Endpoint ep) {
        UpdateDrop drop = new UpdateDrop(graphUri, false);
        UpdateRequest request = new UpdateRequest((Update)drop);
        log.info("deleting {} with request: \n\n{}", (Object)graphUri, (Object)request);
        ep.updateWith(request);
    }

    private <T> T $execute(Query query, Map<String, String> args) {
        Endpoint endpoint = this.endpoints.resolve(query.endpoint());
        long start = System.currentTimeMillis();
        log.info("executing: '{}'", (Object)query);
        Object result = query.evalAt(endpoint, args, Collections.emptyList());
        log.info("executed: '{}' in {} msecs", (Object)query, (Object)(System.currentTimeMillis() - start));
        return result;
    }
}

