/*
 * Decompiled with CFR 0.152.
 */
package org.grade.repo.utils;

import java.util.Iterator;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.grade.common.annotation.Qualifiers;
import org.grade.common.events.ApplicationEvent;
import org.grade.configuration.GraphConfiguration;
import org.grade.repo.Endpoint;
import org.grade.repo.GenericRepository;
import org.grade.repo.Task;
import org.grade.repo.TaskRepository;

@ApplicationScoped
public class TestUtils {
    private static GenericRepository staging;
    private static GenericRepository production;
    private static TaskRepository catalogue;

    public static void configure(@Observes ApplicationEvent.Startup event, @Qualifiers.Staging GenericRepository r1, @Qualifiers.Production GenericRepository r2, TaskRepository r3) {
        staging = r1;
        production = r2;
        catalogue = r3;
    }

    public static Endpoint stagingEndpoint() {
        return staging.endpoints().all().get(0);
    }

    public static Endpoint productionEndpoint() {
        return production.endpoints().all().get(0);
    }

    public static Endpoint taskEndpoint() {
        return catalogue.endpoints().all().get(0);
    }

    public static Task somePublishTask() {
        return TestUtils.somePublishTask(TestUtils.stagingEndpoint(), TestUtils.productionEndpoint());
    }

    public static Task someAddTask() {
        return TestUtils.someAddTask(TestUtils.stagingEndpoint(), TestUtils.productionEndpoint());
    }

    public static Task someRemoveTask() {
        return TestUtils.someRemoveTask(TestUtils.stagingEndpoint(), TestUtils.productionEndpoint());
    }

    public static Task somePublishTask(Endpoint source, Endpoint target) {
        if (source.configuration().graphs().isEmpty()) {
            source.sync();
        }
        if (target.configuration().graphs().isEmpty()) {
            target.sync();
        }
        Iterator targets = target.configuration().graphs().iterator();
        return Task.task().label("some task").operation(Task.Operation.publish).sourceEndpoint(source.configuration().id()).sourceGraphs(source.configuration().graphs().stream().map($ -> $.uri()).collect(Collectors.toSet())).targetEndpoint(target.configuration().id()).transformQuery("describe ?s where { ?s ?p ?o }").targetGraph(targets.hasNext() ? ((GraphConfiguration)targets.next()).uri() : "http://acme.org/rather/virtual/task").creator("http://people/john.doe");
    }

    public static Task someAddTask(Endpoint source, Endpoint target) {
        return TestUtils.somePublishTask(source, target).label("some add task").operation(Task.Operation.add).diffQuery("construct {?s <http://acme.org/addon> 'bit'} where { ?s ?p ?o }");
    }

    public static Task someRemoveTask(Endpoint source, Endpoint target) {
        return TestUtils.somePublishTask(source, target).label("some remove task").operation(Task.Operation.remove).diffQuery("describe ?s where { ?s ?p ?o . filter isLiteral(?o) }");
    }
}

