/*
 * Decompiled with CFR 0.152.
 */
package org.grade.repo;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lombok.NonNull;
import org.grade.configuration.EndpointConfiguration;
import org.grade.configuration.QueryConfiguration;
import org.grade.repo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Queries {
    private static final Logger log = LoggerFactory.getLogger(Queries.class);
    private final List<QueryConfiguration> configs;
    private Consumer<QueryConfiguration> checkAndBind;

    public Queries(@NonNull List<QueryConfiguration> configs, @NonNull List<EndpointConfiguration> endpoints) {
        if (configs == null) {
            throw new IllegalArgumentException("configs is null");
        }
        if (endpoints == null) {
            throw new IllegalArgumentException("endpoints is null");
        }
        this.checkAndBind = this.checkAndBindWith(endpoints);
        configs.forEach(this.checkAndBind);
        this.configs = configs;
    }

    public synchronized Query resolve(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        return this.resolveWith($ -> $.id().equals(key)).orElseGet(() -> this.resolveWith($ -> $.name().equals(key)).orElseThrow(() -> new IllegalStateException("unknown query " + key)));
    }

    public synchronized void register(@NonNull QueryConfiguration configuration) {
        boolean removed;
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is null");
        }
        this.checkAndBind.accept(configuration);
        if (configuration.id() == null || configuration.id().isEmpty()) {
            configuration.id(UUID.randomUUID().toString());
        }
        if (!(removed = this.$remove(configuration.id())) && this.configs.stream().anyMatch($ -> $.name().equals(configuration.name()))) {
            throw new IllegalArgumentException("duplicate query" + configuration.name());
        }
        log.info("{} query: {}", (Object)(removed ? "replaced" : "registered"), (Object)configuration);
        this.configs.add(configuration);
    }

    public synchronized void unregister(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        Query q = this.resolve(key);
        if (q.status() == QueryConfiguration.Status.system) {
            throw new IllegalArgumentException("cannot unregister predefined query '" + q.name() + "'");
        }
        if (this.$remove(q.id())) {
            log.info("unregistered query: {}", (Object)q.name());
        }
    }

    private boolean $remove(String id) {
        Iterator<QueryConfiguration> it = this.configs.iterator();
        while (it.hasNext()) {
            QueryConfiguration qcfg = it.next();
            if (!qcfg.id().equals(id)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    private Optional<Query> resolveWith(Predicate<QueryConfiguration> pred) {
        return this.configs.stream().filter(pred).findFirst().map(Query::queryWith);
    }

    private Consumer<QueryConfiguration> checkAndBindWith(List<EndpointConfiguration> endpoints) {
        return config -> {
            Query.queryWith(config);
            endpoints.stream().filter(ep -> config.endpoint().equals(ep.name())).findFirst().ifPresent(ep -> config.endpoint(ep.id()));
        };
    }
}

