/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.bluebridge.analytics.discovery;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import gr.cite.bluebridge.analytics.discovery.DatabaseCredentials;
import gr.cite.bluebridge.analytics.discovery.ServiceProfile;
import gr.cite.bluebridge.analytics.discovery.exceptions.DatabaseDiscoveryException;
import gr.cite.bluebridge.analytics.portlet.SpringPortal;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DatabaseDiscovery {
    private static Log logger = LogFactoryUtil.getLog(SpringPortal.class);

    public static DatabaseCredentials fetchDatabaseCredentials(ServiceProfile serviceProfile) throws Exception {
        List databaseCredentialsList = DatabaseDiscovery.discoverDatabaseEndpoints((ServiceProfile)serviceProfile);
        if (databaseCredentialsList.isEmpty()) {
            throw new DatabaseDiscoveryException("Did not manage to discover any " + serviceProfile.getServiceClass() + "/" + serviceProfile.getServiceName() + " endpoint");
        }
        DatabaseCredentials databaseCredentials = (DatabaseCredentials)databaseCredentialsList.get(0);
        String decryptedPass = StringEncrypter.getEncrypter().decrypt(databaseCredentials.getDbpass(), new Key[0]);
        databaseCredentials.setDbpass(decryptedPass);
        logger.info((Object)("Managed to find " + serviceProfile.getServiceName() + " database endpoint "));
        logger.info((Object)"Database Credentials");
        logger.info((Object)("name = " + databaseCredentials.getDbname()));
        logger.info((Object)("host = " + databaseCredentials.getDbhost()));
        logger.info((Object)("user = " + databaseCredentials.getDbuser()));
        logger.info((Object)("pass = " + databaseCredentials.getDbpass()));
        return databaseCredentials;
    }

    public static List<DatabaseCredentials> discoverDatabaseEndpoints(ServiceProfile serviceProfile) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'Database'").addCondition("$resource/Profile/Name/text() eq '" + serviceProfile.getServiceName() + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List serviceEndpoints = client.submit((Query)query);
        ArrayList<DatabaseCredentials> databaseCredentialsList = new ArrayList<DatabaseCredentials>();
        if (serviceEndpoints != null) {
            for (ServiceEndpoint sep : serviceEndpoints) {
                for (ServiceEndpoint.AccessPoint ap : sep.profile().accessPoints()) {
                    DatabaseCredentials databaseCredentials = new DatabaseCredentials();
                    databaseCredentials.setDbhost(ap.address());
                    databaseCredentials.setDbname(ap.name());
                    databaseCredentials.setDbuser(ap.username());
                    databaseCredentials.setDbpass(ap.password());
                    databaseCredentialsList.add(databaseCredentials);
                }
            }
        }
        return databaseCredentialsList;
    }
}

