/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.bluebridge.analytics.resources;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import gr.cite.bluebridge.analytics.discovery.DatabaseCredentials;
import gr.cite.bluebridge.analytics.discovery.DatabaseDiscovery;
import gr.cite.bluebridge.analytics.discovery.ServiceDiscovery;
import gr.cite.bluebridge.analytics.discovery.ServiceProfile;
import gr.cite.bluebridge.analytics.discovery.exceptions.DatabaseDiscoveryException;
import gr.cite.bluebridge.analytics.discovery.exceptions.ServiceDiscoveryException;
import gr.cite.bluebridge.analytics.logic.Evaluator;
import gr.cite.bluebridge.analytics.model.Consumption;
import gr.cite.bluebridge.analytics.model.Economics;
import gr.cite.bluebridge.analytics.model.Fish;
import gr.cite.bluebridge.analytics.model.FryGeneration;
import gr.cite.bluebridge.analytics.model.ModelInput;
import gr.cite.bluebridge.analytics.model.Values;
import gr.cite.bluebridge.analytics.resources.Parameters;
import gr.cite.bluebridge.analytics.web.SingletonHttpClient;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class AnalyticsResource {
    private final Logger logger = LoggerFactory.getLogger(AnalyticsResource.class);

    @GET
    @Path(value="ping")
    public String ping() {
        System.out.println("ping");
        return "pong";
    }

    @POST
    @Path(value="performAnalysis")
    @Consumes(value={"application/json"})
    public Response performAnalysis(@HeaderParam(value="scope") String scope, @HeaderParam(value="gcube-token") String token, Parameters params) {
        String invalidParameters = params.validate();
        if (invalidParameters.length() > 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)invalidParameters).build();
        }
        ServiceProfile simulFishGrowthDataAPI = ServiceProfile.createSimulFishGrowthAPI();
        String consumptionString = null;
        try {
            ServiceProfile simulFishGrowthDatabase = ServiceProfile.createSimulFishGrowthDatabase();
            DatabaseCredentials databaseCredentials = DatabaseDiscovery.fetchDatabaseCredentials((ServiceProfile)simulFishGrowthDatabase);
            String serviceApiUrl = ServiceDiscovery.fetchServiceEndpoint((String)scope, (ServiceProfile)simulFishGrowthDataAPI);
            String serviceConsumptionUrl = serviceApiUrl + "Scenario/execute/consumption/160101/170630/218/750000/" + params.getModelId();
            Client client = SingletonHttpClient.getSingletonHttpClient().getClient();
            ClientResponse clientResponse = null;
            WebResource webResource = client.resource(serviceConsumptionUrl);
            clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json")).header("gcube-token", (Object)token)).header("scope", (Object)scope)).header("dbname", (Object)databaseCredentials.getDbname())).header("dbuser", (Object)databaseCredentials.getDbuser())).header("dbhost", (Object)databaseCredentials.getDbhost())).header("dbpass", (Object)databaseCredentials.getDbpass())).get(ClientResponse.class);
            ClientResponse.Status status = clientResponse.getClientResponseStatus();
            consumptionString = (String)clientResponse.getEntity(String.class);
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            String substring = ",";
            String replacement = "";
            int index = consumptionString.lastIndexOf(substring);
            if (index > -1) {
                consumptionString = consumptionString.substring(0, index) + replacement + consumptionString.substring(index + substring.length());
            }
            Consumption consumption = null;
            try {
                consumption = (Consumption)mapper.readValue(consumptionString, Consumption.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ModelInput input = new ModelInput();
            Fish giltheadSeaBream = new Fish();
            giltheadSeaBream.setFish("giltheadSeaBream");
            giltheadSeaBream.setMixPercent(params.getFishMix().doubleValue());
            giltheadSeaBream.setInitialPrice(params.getSellingPrice().doubleValue());
            input.getFishes().add(giltheadSeaBream);
            input.setTaxRate(params.getTaxRate().doubleValue());
            input.setFeedPrice(params.getFeedPrice().doubleValue());
            input.setFryPrice(params.getFryPrice().doubleValue());
            input.setOffShoreAquaFarm(params.getIsOffShoreAquaFarm().booleanValue());
            input.setConsumption(consumption);
            HashMap<Integer, FryGeneration> generationsPerYear = new HashMap<Integer, FryGeneration>();
            generationsPerYear.put(1, new FryGeneration(750000, 2.18));
            generationsPerYear.put(4, new FryGeneration(750000, 2.18));
            generationsPerYear.put(7, new FryGeneration(750000, 2.18));
            generationsPerYear.put(10, new FryGeneration(750000, 2.18));
            input.setGenerationsPerYear(generationsPerYear);
            Economics economics = new Evaluator().calculate(input);
            Evaluator.printValues((Values)economics.getDepreciatedValues());
            Evaluator.printValues((Values)economics.getUndepreciatedValues());
            return Response.ok((Object)economics).build();
        }
        catch (ServiceDiscoveryException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"SimulFishGrowthData Service  could not be discovered").build();
        }
        catch (DatabaseDiscoveryException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"SimulFishGrowthData Database could not be discovered").build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Server Internal Error in Techno Economic Analysis Service").build();
        }
    }
}

