/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.commons.util.datarepository.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import gr.cite.commons.util.datarepository.elements.RelativePathAdapter;
import gr.cite.commons.util.datarepository.utils.InputstreamDeserializer;
import gr.cite.commons.util.datarepository.utils.InputstreamSerializer;
import java.io.InputStream;
import java.net.URI;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="file")
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RepositoryFile {
    public static Logger log = LoggerFactory.getLogger(RepositoryFile.class);
    private String id;
    private String originalName;
    private String dataType;
    private long size = 0L;
    boolean permanent = false;
    @JsonSerialize(using=InputstreamSerializer.class)
    @JsonDeserialize(using=InputstreamDeserializer.class)
    private InputStream inputStream = null;
    private URI uri = null;
    private URI localImage = null;
    private long timestamp;
    private State state = State.TRANSIENT;

    public String getId() {
        return this.id;
    }

    @XmlElement
    public void setId(String id) {
        this.id = id;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    @XmlElement
    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public String getDataType() {
        return this.dataType;
    }

    @XmlElement
    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public long getSize() {
        return this.size;
    }

    @XmlElement
    public void setSize(long size) {
        this.size = size;
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    @XmlElement
    public void setPermanent(boolean permanent) {
        this.permanent = permanent;
    }

    public InputStream getInputStream() {
        if (this.state == State.PERSISTED && this.localImage != null) {
            try {
                this.inputStream = this.localImage.toURL().openStream();
            }
            catch (Exception e) {
                log.error("Unable to obtain stream from local image", (Throwable)e);
            }
        }
        return this.inputStream;
    }

    public boolean hasInputStream() {
        return this.inputStream != null;
    }

    public InputStream peekInputStream() {
        return this.inputStream;
    }

    @XmlTransient
    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI file) {
        this.uri = file;
    }

    public URI getLocalImage() {
        return this.localImage;
    }

    @XmlTransient
    public State getState() {
        return this.state;
    }

    public void markPersisted() {
        this.state = State.PERSISTED;
    }

    @XmlJavaTypeAdapter(value=RelativePathAdapter.class)
    @XmlElement(name="relativePath")
    public void setLocalImage(URI localImage) {
        this.localImage = localImage;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @XmlElement
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public static enum State {
        TRANSIENT,
        PERSISTED;

    }
}

