/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.commons.util.datarepository.elements;

import java.io.File;
import java.net.URI;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class RelativePathAdapter
extends XmlAdapter<URI, URI> {
    private String parentPath;

    public RelativePathAdapter(String parentPath) {
        this.parentPath = parentPath;
    }

    public RelativePathAdapter() {
    }

    public URI unmarshal(URI v) throws Exception {
        if (this.parentPath == null) {
            return new File(v.getPath()).toURI();
        }
        if (this.parentPath.endsWith(File.separator)) {
            return new File(this.parentPath + v.getPath()).toURI();
        }
        return new File(this.parentPath + File.separator + v.getPath()).toURI();
    }

    public URI marshal(URI v) throws Exception {
        if (this.parentPath == null) {
            return new URI(v.toASCIIString().replaceFirst("file:", ""));
        }
        return new URI(v.toASCIIString().replaceFirst("(file:)?" + this.parentPath + "(/)?", ""));
    }
}

