/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.servicelayer;

import gr.cite.gaap.servicelayer.ConfigurationManager;
import gr.cite.geoanalytics.context.GeoServerBridgeConfig;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.layer.LayerConfig;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.presentation.LayerStyle;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.presentation.SystemPresentationConfig;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.presentation.Theme;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.GeoServerBridge;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.Bounds;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.DataStore;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.FeatureType;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.Layer;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.exception.GeoServerBridgeException;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.util.ScaledStyleCreator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EnvironmentInitializer {
    public static Logger log = LoggerFactory.getLogger(EnvironmentInitializer.class);
    private GeoServerBridge geoServerBridge = null;
    private GeoServerBridgeConfig configuration = null;
    private ConfigurationManager configurationManager = null;

    @Inject
    public void setGeoServerBridge(GeoServerBridge geoServerBridge) {
        this.geoServerBridge = geoServerBridge;
    }

    @Inject
    public void setConfiguration(GeoServerBridgeConfig configuration) {
        this.configuration = configuration;
    }

    @Inject
    public void setConfigurationManager(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    private void assertWorkspace() throws GeoServerBridgeException {
        String workSpaceName = this.configuration.getGeoServerBridgeWorkspace();
        Boolean workSpaceExists = this.geoServerBridge.workspaceExists(workSpaceName);
        if (!workSpaceExists.booleanValue()) {
            this.geoServerBridge.addWorkspace(workSpaceName);
            log.debug("Workspace with name " + workSpaceName + " just created");
        } else {
            log.debug("Workspace already exists");
        }
    }

    private void assertDataStore() throws GeoServerBridgeException {
        String dataStoreName;
        DataStore dataStore = new DataStore();
        String workspaceName = this.configuration.getGeoServerBridgeWorkspace();
        Boolean dataStoreExists = this.geoServerBridge.dataStoreExists(workspaceName, dataStoreName = this.configuration.getDataStoreConfig().getDataStoreName());
        if (!dataStoreExists.booleanValue()) {
            dataStore.setHost(this.configuration.getDataStoreConfig().getHost());
            dataStore.setPort(this.configuration.getDataStoreConfig().getPort());
            dataStore.setDatabase(this.configuration.getDataStoreConfig().getDatabaseName());
            dataStore.setUser(this.configuration.getDataStoreConfig().getUser());
            dataStore.setPassword(this.configuration.getDataStoreConfig().getPassword());
            dataStore.setWorkspace(this.configuration.getGeoServerBridgeWorkspace());
            dataStore.setDataStoreName(this.configuration.getDataStoreConfig().getDataStoreName());
            dataStore.setDescription(this.configuration.getDataStoreConfig().getDescription());
            this.geoServerBridge.addDataStore(dataStore);
        }
    }

    private void assertLayers(List<LayerConfig> layerConfigs, SystemPresentationConfig systemPresentationConfig, Map<String, String> slds) throws Exception {
        log.info("Synchronizing layer configuration with remote geospatial server");
        for (LayerConfig lcfg : layerConfigs) {
            log.info("Checking layer: " + lcfg.getName());
            Layer l = this.geoServerBridge.getLayer(lcfg.getName());
            if (l == null) {
                log.info("Layer " + lcfg.getName() + " not found in remote geospatial server. Publishing...");
                Bounds b = new Bounds(lcfg.getBoundingBox().getMinY(), lcfg.getBoundingBox().getMinY(), lcfg.getBoundingBox().getMaxX(), lcfg.getBoundingBox().getMaxY(), "EPSG:4326");
                FeatureType featureType = new FeatureType();
                featureType.setDatastore(this.configuration.getDataStoreConfig().getDataStoreName());
                featureType.setWorkspace(this.configuration.getGeoServerBridgeWorkspace());
                featureType.setEnabled(true);
                featureType.setName(lcfg.getName());
                featureType.setTitle(lcfg.getName());
                featureType.setSrs("EPSG:4326");
                featureType.setNativeCRS("EPSG:4326");
                featureType.setNativeBoundingBox(b);
                featureType.setLatLonBoundingBox(b);
                l = new Layer();
                l.setWorkspace(this.configuration.getGeoServerBridgeWorkspace());
                l.setDatastore(this.configuration.getDataStoreConfig().getDataStoreName());
                l.setEnabled(true);
                String defStyle = systemPresentationConfig.getTermStyle(lcfg.getTermId());
                if (defStyle == null) {
                    defStyle = "default";
                }
                l.setDefaultStyle(defStyle);
                for (Theme th : systemPresentationConfig.getThemes()) {
                    String st = systemPresentationConfig.getTermStyle(th.getTitle(), lcfg.getTermId());
                    if (st == null) continue;
                    l.addStyle(st);
                }
                l.setName(lcfg.getName());
                l.setType("VECTOR");
                this.geoServerBridge.addLayer(l, featureType, slds, lcfg.getMinScale(), lcfg.getMaxScale());
                log.info("Layer " + lcfg.getName() + " successfully published in remote geospatial server");
                continue;
            }
            log.info("Done checking layer: " + lcfg.getName() + " .Layer was found in remote geospatial server");
        }
        log.info("Done synchronizing layer configuration with remote geospatial server");
    }

    private void assertStyles(List<LayerConfig> layerConfigs, SystemPresentationConfig systemPresentationConfig, Map<String, String> slds) throws Exception {
        log.info("Synchronizing style configuration with remote geospatial server");
        HashMap<String, String> styles = new HashMap<String, String>();
        for (LayerConfig lcfg : layerConfigs) {
            for (Theme th : systemPresentationConfig.getThemes()) {
                String scaled;
                String st = systemPresentationConfig.getTermStyle(th.getTitle(), lcfg.getTermId());
                if (st == null || styles.get(scaled = ScaledStyleCreator.getScaledName((String)st, (Integer)lcfg.getMinScale(), (Integer)lcfg.getMaxScale())) != null) continue;
                styles.put(scaled, st);
                log.info("Checking style: " + scaled);
                if (this.geoServerBridge.getStyle(scaled) == null) {
                    log.info("Style " + scaled + " was not found in remote geospatial server. Publishing...");
                    this.geoServerBridge.addStyle(st, slds.get(styles.get(scaled)), lcfg.getMinScale(), lcfg.getMaxScale());
                    log.info("Style " + scaled + " successfully published to remote geospatial server.");
                    continue;
                }
                log.info("Done checking style: " + scaled + ". Style was found in remote geospatial server");
            }
        }
        log.info("Done synchronizing style configuration with remote geospatial server");
    }

    public void asyncInitializeEnvironment() throws Exception {
        ExecutorService es = Executors.newFixedThreadPool(1);
        es.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EnvironmentInitializer.this.initializeEnvironment();
                }
                catch (Exception e) {
                    log.error("Error while initializing environment", (Throwable)e);
                }
            }
        });
    }

    public void initializeEnvironment() throws Exception {
        List<LayerConfig> layerConfigs = this.configurationManager.getLayerConfig();
        SystemPresentationConfig systemPresentationConfig = this.configurationManager.getSystemPresentationConfig();
        this.assertWorkspace();
        this.assertDataStore();
        HashMap<String, String> slds = new HashMap<String, String>();
        List sts = systemPresentationConfig.getLayerStyles();
        for (LayerStyle st : sts) {
            slds.put(st.getName(), st.getStyle());
        }
        this.assertLayers(layerConfigs, systemPresentationConfig, slds);
        this.assertStyles(layerConfigs, systemPresentationConfig, slds);
    }
}

