/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.servicelayer;

import gr.cite.gaap.datatransferobjects.GeocodeMessenger;
import gr.cite.gaap.datatransferobjects.ShapeMessenger;
import gr.cite.geoanalytics.dataaccess.entities.geocode.Geocode;
import gr.cite.geoanalytics.dataaccess.entities.shape.Shape;
import java.util.UUID;

public class ShapeInfo {
    private Shape shape = null;
    private UUID layerID = null;

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public UUID getLayerID() {
        return this.layerID;
    }

    public void setLayerID(UUID layerID) {
        this.layerID = layerID;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShapeInfo)) {
            return false;
        }
        ShapeInfo other = (ShapeInfo)obj;
        return this.getShape().equals((Object)other.getShape()) && this.getLayerID().equals(other.getLayerID());
    }

    public int hashCode() {
        int result = 17;
        result += 37 * result + this.getShape().hashCode();
        result += 37 * result + this.getLayerID().hashCode();
        return result;
    }

    public static class ShapeInfoMessenger {
        private ShapeMessenger shapeMessenger = new ShapeMessenger();
        private GeocodeMessenger geocodeMessenger = new GeocodeMessenger();

        public ShapeInfoMessenger() {
        }

        public ShapeInfoMessenger(Shape shape, Geocode geocode) throws Exception {
            this.shapeMessenger.setCode(shape.getCode());
            this.shapeMessenger.setExtraData(shape.getExtraData());
            this.shapeMessenger.setGeometry(shape.getGeography().toText());
            this.shapeMessenger.setName(shape.getName());
            this.shapeMessenger.setId(shape.getId().toString());
            this.geocodeMessenger = new GeocodeMessenger(geocode);
        }

        public ShapeInfoMessenger(ShapeMessenger shapeMessenger, GeocodeMessenger taxonomyTermMessenger) {
            this.shapeMessenger = shapeMessenger;
            this.geocodeMessenger = taxonomyTermMessenger;
        }

        public ShapeMessenger getShapeMessenger() {
            return this.shapeMessenger;
        }

        public void setShapeMessenger(ShapeMessenger shapeMessenger) {
            this.shapeMessenger = shapeMessenger;
        }

        public GeocodeMessenger getGeocodeMessenger() {
            return this.geocodeMessenger;
        }

        public void setGeocodeMessenger(GeocodeMessenger geocodeMessenger) {
            this.geocodeMessenger = geocodeMessenger;
        }
    }
}

