/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.servicelayer;

import gr.cite.gaap.utilities.TypeUtils;
import gr.cite.geoanalytics.common.ShapeAttributeDataType;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Toolbox {
    private static final String NoMappingKey = "\t\t\t__NoVal__\t\t\t";
    private static final String NoValueKey = "";
    private static final Logger log = LoggerFactory.getLogger(Toolbox.class);
    private Map<String, ShapeAttributeDataType> featureTypes;
    public static final String DefaultCharset = "UTF-8";
    public static final boolean DefaultForceLonLat = false;

    public Toolbox() {
        this.featureTypes = new HashMap<String, ShapeAttributeDataType>();
    }

    public Toolbox(Map<String, ShapeAttributeDataType> featureTypes) {
        this.featureTypes = featureTypes;
    }

    public void addFeatureTypes(Map<String, ShapeAttributeDataType> types) {
        this.featureTypes.putAll(types);
    }

    public void clearFeatureTypes() {
        this.featureTypes.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    private String inferType(AttributeType t, Object value, boolean inferTypes) throws Exception {
        if (t.getBinding().getName().equals(String.class.getName())) {
            String val = (String)value;
            if (this.featureTypes.containsKey(t.getName().toString())) {
                if (this.featureTypes.get(t.getName().toString()) == ShapeAttributeDataType.STRING) return "string";
                switch (this.featureTypes.get(t.getName().toString())) {
                    case SHORT: {
                        Short.parseShort(val);
                        return "short";
                    }
                    case INTEGER: {
                        Integer.parseInt(val);
                        return "integer";
                    }
                    case LONG: {
                        Long.parseLong(val);
                        return "long";
                    }
                    case FLOAT: {
                        Float.parseFloat(val);
                        return "float";
                    }
                    case DOUBLE: {
                        Double.parseDouble(val);
                        return "double";
                    }
                    case DATE: {
                        return "date";
                    }
                    case STRING: 
                    case LONGSTRING: {
                        return "string";
                    }
                }
                throw new Exception("Unrecognized data type: " + t.getBinding().getName());
            }
            if (!inferTypes) return "string";
            if (TypeUtils.tryParseShort((String)val) != null) {
                return "short";
            }
            if (TypeUtils.tryParseInteger((String)val) != null) {
                return "integer";
            }
            if (TypeUtils.tryParseLong((String)val) != null) {
                return "long";
            }
            if (TypeUtils.tryParseFloat((String)val) != null) {
                return "float";
            }
            if (TypeUtils.tryParseDouble((String)val) != null) {
                return "double";
            }
            if (TypeUtils.tryParseDate((String)val, (String)"MMM dd yyyy HH:mm:ss") == null) return "string";
            return "date";
        }
        if (t.getBinding().getName().equals(Integer.class.getName())) {
            Integer val = (Integer)value;
            if (!this.featureTypes.containsKey(t.getName().toString())) return "integer";
            if (this.featureTypes.get(t.getName().toString()) == ShapeAttributeDataType.INTEGER) return "integer";
            switch (this.featureTypes.get(t.getName().toString())) {
                case FLOAT: {
                    return "float";
                }
                case DOUBLE: {
                    return "double";
                }
                case LONG: {
                    return "long";
                }
                case SHORT: {
                    return "integer";
                }
                case STRING: 
                case LONGSTRING: {
                    return "string";
                }
            }
            return "integer";
        }
        if (t.getBinding().getName().equals(Long.class.getName())) {
            Long val = (Long)value;
            if (!this.featureTypes.containsKey(t.getName().toString())) return "long";
            if (this.featureTypes.get(t.getName().toString()) == ShapeAttributeDataType.LONG) return "long";
            switch (this.featureTypes.get(t.getName().toString())) {
                case STRING: 
                case LONGSTRING: {
                    return "string";
                }
                case FLOAT: {
                    return "float";
                }
                case DOUBLE: {
                    return "double";
                }
                case SHORT: 
                case INTEGER: {
                    return "long";
                }
            }
            return "long";
        }
        if (t.getBinding().getName().equals(Short.class.getName())) {
            Short val = (Short)value;
            if (!this.featureTypes.containsKey(t.getName().toString())) return "short";
            if (this.featureTypes.get(t.getName().toString()) == ShapeAttributeDataType.SHORT) return "short";
            switch (this.featureTypes.get(t.getName().toString())) {
                case STRING: 
                case LONGSTRING: {
                    return "string";
                }
                case FLOAT: {
                    return "float";
                }
                case DOUBLE: {
                    return "double";
                }
                case INTEGER: {
                    return "integer";
                }
                case LONG: {
                    return "long";
                }
            }
            return "short";
        }
        if (t.getBinding().getName().equals(Float.class.getName())) {
            Float val = (Float)value;
            if (!this.featureTypes.containsKey(t.getName().toString())) return "float";
            if (this.featureTypes.get(t.getName().toString()) == ShapeAttributeDataType.FLOAT) return "float";
            switch (this.featureTypes.get(t.getName().toString())) {
                case STRING: 
                case LONGSTRING: {
                    return "string";
                }
                case SHORT: 
                case INTEGER: 
                case LONG: {
                    return "float";
                }
                case DOUBLE: {
                    return "double";
                }
            }
            return "float";
        }
        if (t.getBinding().getName().equals(Double.class.getName())) {
            Double val = (Double)value;
            if (!this.featureTypes.containsKey(t.getName().toString())) return "double";
            if (this.featureTypes.get(t.getName().toString()) == ShapeAttributeDataType.DOUBLE) return "double";
            switch (this.featureTypes.get(t.getName().toString())) {
                case STRING: 
                case LONGSTRING: {
                    return "string";
                }
                case SHORT: 
                case INTEGER: 
                case LONG: {
                    return "double";
                }
                case FLOAT: {
                    return "double";
                }
            }
            return "double";
        }
        if (!t.getBinding().getName().equals(Date.class.getName())) throw new Exception("Unrecognized data type: " + t.getBinding().getName());
        Date val = (Date)value;
        if (!this.featureTypes.containsKey(t.getName().toString())) return "date";
        if (this.featureTypes.get(t.getName().toString()) == ShapeAttributeDataType.DATE) return "date";
        switch (this.featureTypes.get(t.getName().toString())) {
            case STRING: 
            case LONGSTRING: {
                return "string";
            }
            case SHORT: 
            case INTEGER: 
            case LONG: {
                return "long";
            }
        }
        return "date";
    }

    private String insertBursaWolfToWKT(String wkt, double[] bursaWolf) {
        String[] defs = wkt.split("DATUM\\[");
        if (defs.length != 2) {
            log.warn("Could not insert Bursa-Wolf Parameters to CRS WKT");
            return wkt;
        }
        int bracketCount = 1;
        int index = 0;
        int prevClose = -1;
        while (bracketCount != 0) {
            int close = defs[1].indexOf(93, index);
            if (prevClose == -1) {
                prevClose = close;
            }
            int open = defs[1].indexOf(91, index);
            if (close == -1) {
                log.warn("Invalid wkt");
                return null;
            }
            if (open < close) {
                ++bracketCount;
                index = open + 1;
            } else {
                --bracketCount;
                index = close + 1;
            }
            if (bracketCount == 0) continue;
            prevClose = close;
        }
        StringBuilder formattedBursaWolf = new StringBuilder();
        for (int i = 0; i < bursaWolf.length; ++i) {
            formattedBursaWolf.append(String.format(Locale.US, "%.2f", bursaWolf[i]));
            if (i == bursaWolf.length - 1) continue;
            formattedBursaWolf.append(", ");
        }
        String res = defs[0] + "DATUM[" + defs[1].substring(0, prevClose + 1) + ", TOWGS84[" + formattedBursaWolf.toString() + "]" + defs[1].substring(prevClose + 1);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> analyzeAttributesOfFeatureSource(SimpleFeatureSource featureSource, boolean inferTypes) throws Exception {
        SimpleFeatureCollection collection = featureSource.getFeatures();
        HashMap<String, String> attributes = new HashMap<String, String>();
        try (SimpleFeatureIterator iterator = collection.features();){
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                List types = feature.getType().getTypes();
                for (AttributeType t : types) {
                    Object val = feature.getAttribute(t.getName());
                    if (val == null) continue;
                    String type = this.inferType(t, val, inferTypes);
                    attributes.put(t.getName().toString(), type);
                }
            }
            HashMap<String, String> hashMap = attributes;
            return hashMap;
        }
    }

    public Map<String, String> analyzeAttributesOfShapeFile(String filename, String charset, boolean inferTypes) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        File file = new File(filename);
        map.put("url", file.toURI().toString());
        map.put("charset", charset);
        SimpleFeatureSource featureSource = null;
        DataStore dataStore = null;
        try {
            dataStore = DataStoreFinder.getDataStore(map);
            featureSource = dataStore.getFeatureSource(dataStore.getTypeNames()[0]);
        }
        catch (IOException e) {
            log.error("Error while reading shape file", (Throwable)e);
            throw e;
        }
        return this.analyzeAttributesOfFeatureSource(featureSource, inferTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAttributeValuesFromFeatureSource(SimpleFeatureSource featureSource, String attribute) throws Exception {
        SimpleFeatureCollection collection = featureSource.getFeatures();
        HashSet<String> values = new HashSet<String>();
        try (SimpleFeatureIterator iterator = collection.features();){
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                List types = feature.getType().getTypes();
                for (AttributeType t : types) {
                    Object val;
                    if (!t.getName().toString().equals(attribute) || (val = feature.getAttribute(t.getName())) == null) continue;
                    values.add(val.toString());
                }
            }
            HashSet<String> hashSet = values;
            return hashSet;
        }
    }

    public Set<String> getAttributeValuesFromShapeFile(String pathname, String charset, String attribute) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        File file = new File(pathname);
        map.put("url", file.toURI().toString());
        map.put("charset", charset);
        SimpleFeatureSource featureSource = null;
        DataStore dataStore = null;
        try {
            dataStore = DataStoreFinder.getDataStore(map);
            featureSource = dataStore.getFeatureSource(dataStore.getTypeNames()[0]);
        }
        catch (IOException e) {
            log.error("Error while reading shape file", (Throwable)e);
            throw e;
        }
        return this.getAttributeValuesFromFeatureSource(featureSource, attribute);
    }
}

