package gr.cite.geoanalytics.dataaccess.geoserverbridge;

import gr.cite.geoanalytics.context.GeoServerBridgeConfig;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.DataStore;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.FeatureType;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.Layer;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.exception.GeoServerBridgeException;

import java.net.URI;
import java.util.List;
import java.util.Map;

public interface GeoServerBridge
{
	public void setConfiguration(GeoServerBridgeConfig configuration);
	
	public List<String> listDataStores() throws GeoServerBridgeException;
	public DataStore getDataStore(String name) throws GeoServerBridgeException;
	
	public List<String> listLayers() throws GeoServerBridgeException;
	public List<String> listLayersOfDataStore(String datastore) throws GeoServerBridgeException;
	
	public Layer getLayer(String name) throws GeoServerBridgeException;
	public List<Layer> getLayers() throws GeoServerBridgeException;
	public List<Layer> getLayersOfDataStore(String datastore) throws GeoServerBridgeException;

	public void addLayer(Layer layer, FeatureType ft, Map<String, String> slds) throws GeoServerBridgeException;
	public void addLayer(Layer layer, FeatureType ft, Map<String, String> slds, Integer minScale, Integer maxScale) throws GeoServerBridgeException;
	
	public void addDataStore(DataStore dataStore) throws GeoServerBridgeException;
	
	public void addWorkspace(String name, String uri) throws GeoServerBridgeException;
	public void addWorkspace(String name, URI uri) throws GeoServerBridgeException;
	public void addWorkspace(String name) throws GeoServerBridgeException;
	
	public void deleteLayer(String name) throws GeoServerBridgeException;
	
	public void setDefaultLayerStyle(String layerName, String styleName, String sld, Integer minScale, Integer maxScale) throws GeoServerBridgeException;
	public void setDefaultLayerStyle(String layerName, String styleName, String sld) throws GeoServerBridgeException;
	
	public void addLayerStyle(String layerName, String styleName, String sld, Integer minScale, Integer maxScale) throws GeoServerBridgeException;
	public void addLayerStyle(String layerName, String styleName, String sld) throws GeoServerBridgeException;
	
	public void removeLayerStyle(String layerName, String styleName, Integer minScale, Integer maxScale) throws GeoServerBridgeException;
	public void removeLayerStyle(String layerName, String styleName) throws GeoServerBridgeException;
	
	
	public FeatureType getFeatureType(String name) throws GeoServerBridgeException;
	
	public String getStyle(String name) throws GeoServerBridgeException;
	public void addStyle(String name, String sld) throws GeoServerBridgeException;
	public void addStyle(String name, String sld, Integer minScale, Integer maxScale) throws GeoServerBridgeException;
	public void removeStyle(String name) throws GeoServerBridgeException;
	public void removeStyle(String name, Integer minScale, Integer maxScale) throws GeoServerBridgeException;

	public Boolean workspaceExists(String workSpaceName) throws GeoServerBridgeException;
	public Boolean dataStoreExists(String workspaceName, String dataStoreName) throws GeoServerBridgeException;
}
