/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.metadata.iso.extent.ExtentImpl;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.util.SimpleInternationalString;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.util.InternationalString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parsers {
    private static Logger log = LoggerFactory.getLogger(Parsers.class);

    public static List<String> parseList(String property) {
        log.debug("Parsing list of properties");
        String[] values = property.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (String value : values) {
            list.add(value);
        }
        return list;
    }

    public static List<TopicCategory> parseTopicCategoryList(String property) {
        log.debug("Parsing list of topic categories");
        String[] values = property.split(",");
        ArrayList<TopicCategory> list = new ArrayList<TopicCategory>();
        for (String value : values) {
            list.add(TopicCategory.valueOf((String)value));
        }
        return list;
    }

    public static ExtentImpl parseExtentList(String property) {
        log.debug("Parsing list of extent");
        String[] values = property.split(",");
        double[] array = new double[4];
        int index = 0;
        ExtentImpl extent = new ExtentImpl();
        for (String value : values) {
            if (value.equals("WORLD")) {
                array[0] = -180.0;
                array[1] = 180.0;
                array[2] = -90.0;
                array[3] = 90.0;
                log.trace("Setting default values for extent: " + array);
                break;
            }
            array[index] = Double.parseDouble(value);
            ++index;
        }
        extent.setGeographicElements(Collections.singleton(new GeographicBoundingBoxImpl(array[0], array[1], array[2], array[3])));
        extent.setDescription((InternationalString)new SimpleInternationalString("Bounding box"));
        return extent;
    }
}

