/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.wrappers;

import gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.wrappers.GcubeISOmetadata;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.wrappers.MetaDataImpL;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.gcube.spatial.data.geonetwork.iso.Thesaurus;
import org.geotools.metadata.iso.citation.AddressImpl;
import org.geotools.metadata.iso.citation.CitationDateImpl;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.metadata.iso.citation.ContactImpl;
import org.geotools.metadata.iso.citation.OnLineResourceImpl;
import org.geotools.metadata.iso.citation.ResponsiblePartyImpl;
import org.geotools.metadata.iso.constraint.LegalConstraintsImpl;
import org.geotools.metadata.iso.identification.BrowseGraphicImpl;
import org.geotools.metadata.iso.identification.DataIdentificationImpl;
import org.geotools.metadata.iso.identification.KeywordsImpl;
import org.geotools.metadata.iso.identification.ResolutionImpl;
import org.geotools.metadata.iso.maintenance.MaintenanceInformationImpl;
import org.geotools.metadata.iso.spatial.GeometricObjectsImpl;
import org.geotools.metadata.iso.spatial.VectorSpatialRepresentationImpl;
import org.geotools.util.SimpleInternationalString;
import org.opengis.metadata.citation.Address;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.OnLineResource;
import org.opengis.metadata.citation.Role;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.constraint.Restriction;
import org.opengis.metadata.identification.CharacterSet;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.maintenance.MaintenanceFrequency;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.spatial.SpatialRepresentation;
import org.opengis.util.InternationalString;

public class ISOmetadataFactory {
    public static MetaDataImpL generateMeta(GcubeISOmetadata gcubeISOmetadata) throws URISyntaxException {
        ResponsiblePartyImpl auThor = new ResponsiblePartyImpl();
        auThor.setIndividualName(gcubeISOmetadata.getUser());
        auThor.setOrganisationName((InternationalString)new SimpleInternationalString(gcubeISOmetadata.getConfig().getProjectName()));
        auThor.setRole(Role.AUTHOR);
        ResponsiblePartyImpl disTributor = new ResponsiblePartyImpl();
        disTributor.setIndividualName(gcubeISOmetadata.getConfig().getDistributorIndividualName());
        disTributor.setOrganisationName((InternationalString)new SimpleInternationalString(gcubeISOmetadata.getConfig().getProjectName()));
        disTributor.setRole(Role.DISTRIBUTOR);
        ContactImpl distriButorContact = new ContactImpl();
        AddressImpl distriButorAddress = new AddressImpl();
        distriButorAddress.getElectronicMailAddresses().add(gcubeISOmetadata.getConfig().getDistributorEMail());
        distriButorContact.setAddress((Address)distriButorAddress);
        OnLineResourceImpl distriButorOnline = new OnLineResourceImpl(new URI(gcubeISOmetadata.getConfig().getDistributorSite()));
        distriButorContact.setOnLineResource((OnLineResource)distriButorOnline);
        disTributor.setContactInfo((Contact)distriButorContact);
        ResponsiblePartyImpl proVider = new ResponsiblePartyImpl();
        proVider.setIndividualName(gcubeISOmetadata.getConfig().getProviderIndividualName());
        proVider.setOrganisationName((InternationalString)new SimpleInternationalString(gcubeISOmetadata.getConfig().getProjectName()));
        proVider.setRole(Role.RESOURCE_PROVIDER);
        ContactImpl proViderContact = new ContactImpl();
        AddressImpl proViderAddress = new AddressImpl();
        proViderAddress.getElectronicMailAddresses().add(gcubeISOmetadata.getConfig().getProviderEMail());
        proViderContact.setAddress((Address)proViderAddress);
        OnLineResourceImpl proViderOnline = new OnLineResourceImpl(new URI(gcubeISOmetadata.getConfig().getProviderSite()));
        proViderContact.setOnLineResource((OnLineResource)proViderOnline);
        proVider.setContactInfo((Contact)proViderContact);
        DataIdentificationImpl iDent = new DataIdentificationImpl();
        CitationImpl ciTation = new CitationImpl();
        ciTation.setTitle((InternationalString)new SimpleInternationalString(gcubeISOmetadata.getTitle()));
        ciTation.getDates().add(new CitationDateImpl(gcubeISOmetadata.getCreationDate(), DateType.CREATION));
        ciTation.getPresentationForm().add(gcubeISOmetadata.getPresentationForm());
        iDent.setCitation((Citation)ciTation);
        iDent.setAbstract((InternationalString)new SimpleInternationalString(gcubeISOmetadata.getAbstractField()));
        iDent.setPurpose((InternationalString)new SimpleInternationalString(gcubeISOmetadata.getPurpose()));
        iDent.getCredits().addAll(gcubeISOmetadata.getCredits());
        iDent.getResourceMaintenance().add(new MaintenanceInformationImpl(MaintenanceFrequency.AS_NEEDED));
        for (Map.Entry<Thesaurus, HashSet<String>> entry : gcubeISOmetadata.getDescriptiveKeywords().entrySet()) {
            KeywordsImpl keyWords = new KeywordsImpl();
            for (String key : entry.getValue()) {
                keyWords.getKeywords().add(new SimpleInternationalString(key));
            }
            keyWords.setType(entry.getKey().getType());
            CitationImpl theSaurus = new CitationImpl();
            theSaurus.setTitle((InternationalString)new SimpleInternationalString(entry.getKey().getTitle()));
            theSaurus.getDates().add(new CitationDateImpl(entry.getKey().getCitationDate(), DateType.CREATION));
            if (entry.getKey().isAuthored()) {
                theSaurus.setOtherCitationDetails((InternationalString)new SimpleInternationalString(entry.getKey().getCitationDescription()));
                ResponsiblePartyImpl theSaurusParty = new ResponsiblePartyImpl();
                theSaurusParty.setIndividualName(entry.getKey().getTitle());
                theSaurusParty.setOrganisationName((InternationalString)new SimpleInternationalString(entry.getKey().getCitationOrganization()));
                theSaurusParty.setRole(Role.POINT_OF_CONTACT);
                ContactImpl theSaurusContact = new ContactImpl();
                theSaurusContact.setOnLineResource((OnLineResource)new OnLineResourceImpl(new URI(entry.getKey().getCitationUri())));
                theSaurusParty.setContactInfo((Contact)theSaurusContact);
                theSaurus.getCitedResponsibleParties().add(theSaurusParty);
            }
            keyWords.setThesaurusName((Citation)theSaurus);
            iDent.getDescriptiveKeywords().add(keyWords);
        }
        iDent.getTopicCategories().addAll(gcubeISOmetadata.getTopicCategories());
        iDent.getExtent().add(gcubeISOmetadata.getExtent());
        GeometricObjectsImpl gEoObjs = new GeometricObjectsImpl();
        gEoObjs.setGeometricObjectType(gcubeISOmetadata.getGeometricObjectType());
        gEoObjs.setGeometricObjectCount(Integer.valueOf(gcubeISOmetadata.getGeometryCount()));
        VectorSpatialRepresentationImpl sPatial = new VectorSpatialRepresentationImpl();
        sPatial.setTopologyLevel(gcubeISOmetadata.getTopologyLevel());
        sPatial.getGeometricObjects().add(gEoObjs);
        ResolutionImpl layErResolution = new ResolutionImpl();
        layErResolution.setDistance(Double.valueOf(gcubeISOmetadata.getResolution()));
        for (String uri : gcubeISOmetadata.getGraphicOverviewsURI()) {
            BrowseGraphicImpl gRaph = new BrowseGraphicImpl(new URI(uri));
            iDent.getGraphicOverviews().add(gRaph);
        }
        LegalConstraintsImpl cOnstraints = new LegalConstraintsImpl();
        cOnstraints.getUseLimitation().add(new SimpleInternationalString(gcubeISOmetadata.getConfig().getLicense()));
        cOnstraints.getAccessConstraints().add(Restriction.LICENSE);
        cOnstraints.getUseConstraints().add(Restriction.LICENSE);
        MetaDataImpL mEta = new MetaDataImpL(auThor, new Date(), (Identification)iDent);
        mEta.setCharacterSet(CharacterSet.UTF_8);
        mEta.getContacts().add(disTributor);
        mEta.getContacts().add(proVider);
        mEta.getSpatialRepresentationInfo().add((SpatialRepresentation)sPatial);
        mEta.getMetadataConstraints().add((Constraints)cOnstraints);
        mEta.setLanguage(Locale.ENGLISH);
        mEta.getHierarchyLevels().add(ScopeCode.DATASET);
        mEta.setFileIdentifier(UUID.randomUUID().toString());
        return mEta;
    }
}

