/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.geoserverbridge.util;

import gr.cite.geoanalytics.dataaccess.geoserverbridge.exception.GeoServerBridgeException;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ScaledStyleCreator {
    public static Logger log = LoggerFactory.getLogger(ScaledStyleCreator.class);

    public static synchronized String createScaled(String baseSld, Integer minScale, Integer maxScale) throws GeoServerBridgeException {
        log.debug("Creating Scaled...");
        if (baseSld == null) {
            return null;
        }
        if (minScale == null && maxScale == null) {
            return baseSld;
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document d = db.parse(new ByteArrayInputStream(baseSld.getBytes("UTF-8")));
            NodeList userStyles = d.getElementsByTagName("UserStyle");
            for (int i = 0; i < userStyles.getLength(); ++i) {
                Element userStyle = (Element)userStyles.item(i);
                NodeList featureTypeStyles = userStyle.getElementsByTagName("FeatureTypeStyle");
                for (int j = 0; j < featureTypeStyles.getLength(); ++j) {
                    Element featureTypeStyle = (Element)featureTypeStyles.item(j);
                    NodeList rules = featureTypeStyle.getElementsByTagName("Rule");
                    for (int k = 0; k < rules.getLength(); ++k) {
                        Element minSdEl = null;
                        Element maxSdEl = null;
                        Integer minSd = null;
                        Integer maxSd = null;
                        Element rule = (Element)rules.item(k);
                        NodeList msds = rule.getElementsByTagName("MinScaleDenominator");
                        if (msds != null && msds.getLength() != 0) {
                            if (msds.getLength() != 1) {
                                log.error("More than one MinScaleDenominator elements were found within a rule");
                                throw new Exception("More than one MinScaleDenominator elements were found within a rule");
                            }
                            minSdEl = (Element)msds.item(0);
                            minSd = Integer.parseInt(minSdEl.getFirstChild().getNodeValue().trim());
                        }
                        if ((msds = rule.getElementsByTagName("MaxScaleDenominator")) != null && msds.getLength() != 0) {
                            if (msds.getLength() != 1) {
                                log.error("More than one MaxScaleDenominator elements were found within a rule");
                                throw new Exception("More than one MaxScaleDenominator elements were found within a rule");
                            }
                            maxSdEl = (Element)msds.item(0);
                            maxSd = Integer.parseInt(maxSdEl.getFirstChild().getNodeValue().trim());
                        }
                        if (minSd != null && minScale != null && minSd < minScale) {
                            minSdEl.getFirstChild().setNodeValue(minScale.toString());
                        }
                        if (maxSd != null && maxScale != null && maxSd > maxScale) {
                            maxSdEl.getFirstChild().setNodeValue(maxScale.toString());
                        }
                        if (minSd == null && minScale != null) {
                            minSdEl = d.createElement("MinScaleDenominator");
                            minSdEl.appendChild(d.createTextNode(minScale.toString()));
                            rule.appendChild(minSdEl);
                        }
                        if (maxSd != null || maxScale == null) continue;
                        maxSdEl = d.createElement("MaxScaleDenominator");
                        maxSdEl.appendChild(d.createTextNode(maxScale.toString()));
                        rule.appendChild(maxSdEl);
                    }
                }
            }
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("encoding", "UTF-8");
            StringWriter sw = new StringWriter();
            serializer.transform(new DOMSource(d), new StreamResult(sw));
            return sw.toString();
        }
        catch (Exception e) {
            log.error("An error has occurred while creating a scaled style", (Throwable)e);
            throw new GeoServerBridgeException("An error has occurred while creating a scaled style", e);
        }
    }

    public static synchronized String getScaledName(String name, Integer minScale, Integer maxScale) {
        log.debug("Getting Scaled Name...");
        String scaledName = name;
        if (minScale != null) {
            scaledName = scaledName + "-m" + minScale.toString();
        }
        if (maxScale != null) {
            scaledName = scaledName + "-M" + maxScale.toString();
        }
        return scaledName;
    }
}

