/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.dao;

import gr.cite.geoanalytics.dataaccess.dao.Dao;
import gr.cite.geoanalytics.dataaccess.dao.UUIDGenerator;
import gr.cite.geoanalytics.dataaccess.entities.Entity;
import gr.cite.geoanalytics.dataaccess.entities.Identifiable;
import gr.cite.geoanalytics.dataaccess.entities.Stampable;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnitUtil;

public abstract class JpaDao<T extends Entity, PK extends Serializable>
implements Dao<T, PK> {
    protected Class<T> entityClass;
    @PersistenceContext
    protected EntityManager entityManager;
    protected PersistenceUnitUtil persistenceUnitUtil;

    public JpaDao() {
        ParameterizedType genericSuperclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.entityClass = (Class)genericSuperclass.getActualTypeArguments()[0];
    }

    @PostConstruct
    private void initPersistenceUnitUtil() {
        this.persistenceUnitUtil = this.entityManager.getEntityManagerFactory().getPersistenceUnitUtil();
    }

    @Override
    public T create(T t) {
        if (t instanceof Identifiable && ((Identifiable)t).getId() == null) {
            ((Identifiable)t).setId(UUIDGenerator.randomUUID());
        }
        if (t instanceof Stampable) {
            if (((Stampable)t).getCreationDate() == null) {
                ((Stampable)t).setCreationDate(new Date(Calendar.getInstance().getTimeInMillis()));
            }
            if (((Stampable)t).getLastUpdate() == null) {
                ((Stampable)t).setLastUpdate(new Date(Calendar.getInstance().getTimeInMillis()));
            }
        }
        this.entityManager.persist(t);
        return t;
    }

    @Override
    public T read(PK id) {
        return (T)((Entity)this.entityManager.find(this.entityClass, id));
    }

    @Override
    public T update(T t) {
        if (t instanceof Stampable) {
            ((Stampable)t).setLastUpdate(new Date(Calendar.getInstance().getTimeInMillis()));
        }
        return (T)((Entity)this.entityManager.merge(t));
    }

    @Override
    public void delete(T t) {
        t = (Entity)this.entityManager.merge(t);
        this.entityManager.remove(t);
    }

    @Override
    public List<T> getAll() {
        return this.entityManager.createQuery("from " + this.entityClass.getSimpleName(), this.entityClass).getResultList();
    }

    @Override
    public long count() {
        return ((Number)this.entityManager.createQuery("select count(e) from " + this.entityClass.getSimpleName() + " e").getSingleResult()).longValue();
    }

    @Override
    public boolean isLoaded(T t) {
        return this.persistenceUnitUtil.isLoaded(t);
    }

    protected boolean isFieldLoaded(T t, String fieldName) {
        return this.persistenceUnitUtil.isLoaded(t, fieldName);
    }
}

