package gr.cite.geoanalytics.dataaccess.entities.project.dao;

import javax.persistence.NoResultException;
import javax.persistence.Query;

import org.springframework.stereotype.Repository;

import gr.cite.geoanalytics.dataaccess.dao.JpaDao;
import gr.cite.geoanalytics.dataaccess.entities.document.Document;
import gr.cite.geoanalytics.dataaccess.entities.project.Project;
import gr.cite.geoanalytics.dataaccess.entities.project.ProjectDocument;
import gr.cite.geoanalytics.dataaccess.entities.project.ProjectDocumentPK;

@Repository
public class ProjectDocumentDaoImpl extends JpaDao<ProjectDocument, ProjectDocumentPK> implements ProjectDocumentDao {

	@Override
	public ProjectDocument find(Project p, Document d) {
		Query query = entityManager.createQuery("from ProjectDocument pd where pd.project = :p and pd.document = :d", 
				ProjectDocument.class);
		query.setParameter("p", p);
		query.setParameter("d", d);
		
		try
		{
			return (ProjectDocument)query.getSingleResult();
		}catch(NoResultException e)
		{
			return null;
		}
	}

	@Override
	public void deleteByDocument(Document d) {
		Query query = entityManager.createQuery("delete ProjectDocument pd where pd.document = :d");
		query.setParameter("d", d);
		query.executeUpdate();
	}

	@Override
	public void deleteByProject(Project p) {
		Query query = entityManager.createQuery("delete ProjectDocument pd where pd.project = :p");
		query.setParameter("p", p);
		query.executeUpdate();		
	}

	@Override
	public ProjectDocument loadDetails(ProjectDocument pd) {
		pd.getCreator().getName();
		pd.getDocument().getId();
		pd.getProject().getId();
		return pd;
	}

}
