package gr.cite.geoanalytics.dataaccess.entities.project.dao;

import java.util.List;
import java.util.UUID;

import gr.cite.geoanalytics.dataaccess.dao.Dao;
import gr.cite.geoanalytics.dataaccess.entities.project.Project;
import gr.cite.geoanalytics.dataaccess.entities.project.ProjectTerm;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.Taxonomy;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.TaxonomyTerm;
import gr.cite.geoanalytics.dataaccess.entities.tenant.Tenant;

public interface ProjectTermDao extends Dao<ProjectTerm, UUID>
{
	public ProjectTerm find(Project p, TaxonomyTerm tt);
	public List<TaxonomyTerm> findByProject(Project p);
	public List<Taxonomy> findByTenant(Tenant c);
	public TaxonomyTerm findByProjectAndTaxonomy(Project p, Taxonomy t);
	public List<Project> findByTerm(TaxonomyTerm tt);
	public void deleteByProject(Project p);
	public void deleteByTerm(TaxonomyTerm tt);
}
