/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.taxonomy.dao;

import gr.cite.geoanalytics.dataaccess.dao.JpaDao;
import gr.cite.geoanalytics.dataaccess.entities.shape.Shape;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.TaxonomyTerm;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.TaxonomyTermShape;
import gr.cite.geoanalytics.dataaccess.entities.taxonomy.dao.TaxonomyTermShapeDao;
import java.util.List;
import java.util.UUID;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.springframework.stereotype.Repository;

@Repository
public class TaxonomyTermShapeDaoImpl
extends JpaDao<TaxonomyTermShape, UUID>
implements TaxonomyTermShapeDao {
    @Override
    public TaxonomyTermShape find(TaxonomyTerm tt, Shape s) {
        TypedQuery query = this.entityManager.createQuery("from TaxonomyTermShape tts where tts.term = :t and tts.shape = :s", TaxonomyTermShape.class);
        query.setParameter("t", (Object)tt);
        query.setParameter("s", (Object)s);
        try {
            return (TaxonomyTermShape)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public void deleteByTerm(TaxonomyTerm tt) {
        Query query = this.entityManager.createQuery("delete TaxonomyTermShape tts where tts.term = :tt");
        query.setParameter("tt", (Object)tt);
        query.executeUpdate();
    }

    @Override
    public TaxonomyTermShape findUniqueByTerm(TaxonomyTerm tt) {
        TypedQuery query = this.entityManager.createQuery("select tts from TaxonomyTermShape tts where tts.term = :tt", TaxonomyTermShape.class);
        query.setParameter("tt", (Object)tt);
        try {
            return (TaxonomyTermShape)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public List<TaxonomyTermShape> findByTerm(TaxonomyTerm tt) {
        TypedQuery query = this.entityManager.createQuery("select tts from TaxonomyTermShape tts where tts.term = :tt", TaxonomyTermShape.class);
        query.setParameter("tt", (Object)tt);
        return query.getResultList();
    }

    @Override
    public List<TaxonomyTermShape> findNonProjectByTerm(TaxonomyTerm tt) {
        TypedQuery query = this.entityManager.createQuery("select distinct tts from TaxonomyTermShape tts where tts not in (select distinct tts2 from TaxonomyTermShape tts2, Shape s2, Project p where tts2.shape = s2 and tts2.term = :tt and s2.id = p.shape) and tts.term = :tt", TaxonomyTermShape.class);
        query.setParameter("tt", (Object)tt);
        return query.getResultList();
    }

    @Override
    public List<TaxonomyTermShape> findByShape(Shape s) {
        TypedQuery query = this.entityManager.createQuery("select tts from TaxonomyTermShape tts where tts.shape = :s", TaxonomyTermShape.class);
        query.setParameter("s", (Object)s);
        return query.getResultList();
    }

    @Override
    public TaxonomyTermShape loadDetails(TaxonomyTermShape tts) {
        tts.getCreator().getName();
        tts.getTerm().getId();
        tts.getShape().getId();
        return tts;
    }
}

