/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.security.accesscontrol.dao;

import gr.cite.geoanalytics.dataaccess.dao.JpaDao;
import gr.cite.geoanalytics.dataaccess.entities.principal.AccessControl;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.security.accesscontrol.dao.AccessControlDao;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.springframework.stereotype.Repository;

@Repository
public class AccessControlDaoImpl
extends JpaDao<AccessControl, UUID>
implements AccessControlDao {
    @Override
    public AccessControl findByPrincipalUUIDAndEntity(UUID principalId, UUID entityId) {
        StringBuilder queryB = new StringBuilder();
        queryB.append("FROM AccessControl ac");
        queryB.append(" WHERE ac.principal.id = :principalId");
        queryB.append(" AND ac.entity = :entityId");
        TypedQuery query = this.entityManager.createQuery(queryB.toString(), AccessControl.class);
        query.setParameter("principalId", (Object)principalId);
        query.setParameter("entityId", (Object)entityId);
        AccessControl result = null;
        result = (AccessControl)query.getSingleResult();
        return result;
    }

    @Override
    public AccessControl findByPrincipalAndEntity(Principal principal, UUID entity) {
        StringBuilder queryB = new StringBuilder("from AccessControl ac where ac.principal = :principal and ac.entity = :entity");
        TypedQuery query = this.entityManager.createQuery(queryB.toString(), AccessControl.class);
        query.setParameter("principal", (Object)principal);
        query.setParameter("entity", (Object)entity);
        AccessControl result = null;
        try {
            result = (AccessControl)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        return result;
    }

    @Override
    public AccessControl findByPrincipal(Principal principal) {
        StringBuilder queryB = new StringBuilder("from AccessControl ac where ac.principal = :principal");
        TypedQuery query = this.entityManager.createQuery(queryB.toString(), AccessControl.class);
        query.setParameter("principal", (Object)principal);
        AccessControl result = null;
        try {
            result = (AccessControl)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        return result;
    }

    @Override
    public List<AccessControl> findByEntity(UUID entityId) {
        StringBuilder queryB = new StringBuilder("from AccessControl ac where ac.entity = :entity");
        TypedQuery query = this.entityManager.createQuery(queryB.toString(), AccessControl.class);
        query.setParameter("entity", (Object)entityId);
        ArrayList<AccessControl> result = new ArrayList();
        try {
            result = query.getResultList();
        }
        catch (NoResultException e) {
            return new ArrayList<AccessControl>();
        }
        return result;
    }

    @Override
    public Boolean hasPrincipalPermissionForEntity(Principal principal, UUID entity) {
        Boolean result = false;
        StringBuilder queryB = new StringBuilder("select ac from AccessControl ac, PrincipalMembership pm where ((ac.principal = :principal and ac.entity = :entity)");
        queryB.append(" or (pm.member = :principal and pm.group = ac.principal and ac.entity = :entity))");
        TypedQuery query = this.entityManager.createQuery(queryB.toString(), AccessControl.class);
        query.setParameter("principal", (Object)principal);
        query.setParameter("entity", (Object)entity);
        result = !query.getResultList().isEmpty();
        return result;
    }

    @Override
    public AccessControl loadDetails(AccessControl ac) {
        ac.getPrincipal().getName();
        return ac;
    }

    @Override
    public Boolean hasPrincipalReadPermissionForEntity(Principal principal, UUID entityId) {
        Boolean result = false;
        StringBuilder queryB = new StringBuilder();
        queryB.append("SELECT ac FROM AccessControl ac, PrincipalMembership pm");
        queryB.append(" WHERE ((ac.principal = :principal AND ac.entity = :entity AND ac.readRight = 1)");
        queryB.append(" OR (pm.member = :principal AND pm.group = ac.principal AND ac.entity = :entity AND ac.readRight = 1))");
        TypedQuery query = this.entityManager.createQuery(queryB.toString(), AccessControl.class);
        query.setParameter("principal", (Object)principal);
        query.setParameter("entity", (Object)entityId);
        result = !query.getResultList().isEmpty();
        return result;
    }

    @Override
    public Boolean hasPrincipalEditPermissionForEntity(Principal principal, UUID entityId) {
        Boolean result = false;
        StringBuilder queryB = new StringBuilder();
        queryB.append("SELECT ac FROM AccessControl ac, PrincipalMembership pm");
        queryB.append(" WHERE ((ac.principal = :principal AND ac.entity = :entity AND ac.editRight = 1)");
        queryB.append(" OR (pm.member = :principal AND pm.group = ac.principal AND ac.entity = :entity AND ac.editRight = 1))");
        TypedQuery query = this.entityManager.createQuery(queryB.toString(), AccessControl.class);
        query.setParameter("principal", (Object)principal);
        query.setParameter("entity", (Object)entityId);
        result = !query.getResultList().isEmpty();
        return result;
    }

    @Override
    public Boolean hasPrincipalDeletePermissionForEntity(Principal principal, UUID entityId) {
        Boolean result = false;
        StringBuilder queryB = new StringBuilder();
        queryB.append("SELECT ac FROM AccessControl ac, PrincipalMembership pm");
        queryB.append(" WHERE ((ac.principal = :principal AND ac.entity = :entity AND ac.deleteRight = 1)");
        queryB.append(" OR (pm.member = :principal AND pm.group = ac.principal AND ac.entity = :entity AND ac.deleteRight = 1))");
        TypedQuery query = this.entityManager.createQuery(queryB.toString(), AccessControl.class);
        query.setParameter("principal", (Object)principal);
        query.setParameter("entity", (Object)entityId);
        result = !query.getResultList().isEmpty();
        return result;
    }

    @Override
    public void deleteByEntityId(UUID accessControlId) {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("DELETE FROM AccessControl ac WHERE ac.entity = :accessControlId");
        Query query = this.entityManager.createQuery(queryStr.toString());
        query.setParameter("accessControlId", (Object)accessControlId);
        query.executeUpdate();
    }

    @Override
    public void deleteByPrincipalAndEntityId(Principal principal, UUID entityId) {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("DELETE FROM AccessControl ac WHERE ac.entity = :entityId AND ac.principal = :principal");
        Query query = this.entityManager.createQuery(queryStr.toString());
        query.setParameter("accessControlId", (Object)entityId);
        query.setParameter("principal", (Object)principal);
        query.executeUpdate();
    }

    @Override
    public void deleteByPrincipalId(UUID id) throws Exception {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("DELETE FROM AccessControl ac WHERE ac.principal.id = :id");
        Query query = this.entityManager.createQuery(queryStr.toString());
        query.setParameter("id", (Object)id);
        query.executeUpdate();
    }

    @Override
    public void deleteByPrincipalUUIDsAndEntityId(List<UUID> principalID, UUID entityId) {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("DELETE FROM AccessControl ac");
        queryStr.append(" WHERE ac.entity = :entityId");
        queryStr.append(" AND ac.principal.id IN :principalID");
        Query query = this.entityManager.createQuery(queryStr.toString());
        query.setParameter("entityId", (Object)entityId);
        query.setParameter("principalID", principalID);
        query.executeUpdate();
    }
}

