/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.workflow.dao;

import gr.cite.geoanalytics.dataaccess.dao.JpaDao;
import gr.cite.geoanalytics.dataaccess.entities.project.Project;
import gr.cite.geoanalytics.dataaccess.entities.workflow.Workflow;
import gr.cite.geoanalytics.dataaccess.entities.workflow.WorkflowTask;
import gr.cite.geoanalytics.dataaccess.entities.workflow.dao.WorkflowDao;
import java.util.List;
import java.util.UUID;
import javax.persistence.TypedQuery;
import org.springframework.stereotype.Repository;

@Repository
public class WorkflowDaoImpl
extends JpaDao<Workflow, UUID>
implements WorkflowDao {
    @Override
    public List<Workflow> getByProject(Project p) {
        TypedQuery query = this.entityManager.createQuery("from Workflow w where w.project = :p", Workflow.class);
        query.setParameter("p", (Object)p);
        return query.getResultList();
    }

    @Override
    public List<WorkflowTask> getWorkflowTasks(Workflow w) {
        TypedQuery query = this.entityManager.createQuery("from WorkflowTask wt where wt.workflow = :w", WorkflowTask.class);
        query.setParameter("w", (Object)w);
        return query.getResultList();
    }

    @Override
    public List<WorkflowTask> getWorkflowTasks(Workflow w, WorkflowTask.Criticality c) {
        TypedQuery query = this.entityManager.createQuery("from WorkflowTask wt where wt.workflow = :w and wt.critical = :c", WorkflowTask.class);
        query.setParameter("w", (Object)w);
        query.setParameter("c", (Object)c.criticalityCode());
        return query.getResultList();
    }

    @Override
    public List<WorkflowTask> getWorkflowTasks(Workflow w, WorkflowTask.Criticality c, WorkflowTask.WorkflowTaskStatus s) {
        TypedQuery query = this.entityManager.createQuery("from WorkflowTask wt where wt.workflow = :w and wt.critical = :c and wt.status = :s", WorkflowTask.class);
        query.setParameter("w", (Object)w);
        query.setParameter("c", (Object)c.criticalityCode());
        query.setParameter("s", (Object)s.statusCode());
        return query.getResultList();
    }

    @Override
    public Workflow loadDetails(Workflow w) {
        w.getCreator().getName();
        w.getProject().getId();
        if (w.getTemplate() != null) {
            w.getTemplate().getId();
        }
        return w;
    }
}

