package gr.cite.geoanalytics.dataaccess.entities.layer;

import java.util.UUID;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import org.hibernate.annotations.Type;

import java.io.Serializable;

import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.tenant.Tenant;

@Entity
@Table(name = "\"LayerTenant\"")
public class LayerTenant implements gr.cite.geoanalytics.dataaccess.entities.Entity, Serializable {
	
	private static final long serialVersionUID = 1362579047583240048L;

	@Id
	@Type(type="org.hibernate.type.PostgresUUIDType") //DEPWARN dependency to Hibernate and PostgreSQL
	@Column(name = "lt_id", nullable = false)
	private UUID lt_id;
	
	@Type(type="org.hibernate.type.PostgresUUIDType") //DEPWARN dependency to Hibernate and PostgreSQL
	@Column(name = "\"TEN_ID\"", nullable = false)
	private UUID ten_id;

	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "l_id", nullable = false)
	private Layer layer = null;
	
	public UUID getLt_id() {
		return lt_id;
	}

	public void setLt_id(UUID lt_id) {
		this.lt_id = lt_id;
	}


	public UUID getTen_id() {
		return ten_id;
	}

	public void setTen_id(UUID ten_id) {
		this.ten_id = ten_id;
	}

	public Layer getLayer() {
		return this.layer;
	}
	
	public void setLayer(Layer layer) {
		this.layer = layer;
	}
	
	
}
