/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.taxonomy;

import gr.cite.geoanalytics.dataaccess.entities.Entity;
import gr.cite.geoanalytics.dataaccess.entities.Identifiable;
import gr.cite.geoanalytics.dataaccess.entities.Stampable;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import java.util.Date;
import java.util.UUID;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Type;

@javax.persistence.Entity
@Table(name="\"GeocodeSystem\"")
public class GeocodeSystem
implements Entity,
Identifiable,
Stampable {
    @Id
    @Type(type="org.hibernate.type.PostgresUUIDType")
    @Column(name="\"GCS_ID\"", nullable=false)
    private UUID id = null;
    @Column(name="\"GCS_Name\"", nullable=false, length=250)
    private String name = null;
    @Column(name="\"GCS_IsUserTaxonomy\"", nullable=false)
    private short isUserTaxonomy = 0;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"GCS_CreationDate\"", nullable=false)
    private Date creationDate = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"GCS_LastUpdate\"", nullable=false)
    private Date lastUpdate = null;
    @Column(name="\"GCS_IsActive\"", nullable=false)
    private Short isActive = 1;
    @Type(type="gr.cite.geoanalytics.dataaccess.typedefinition.XMLType")
    @Basic(fetch=FetchType.LAZY)
    @Column(name="\"GCS_ExtraData\"", columnDefinition="xml", nullable=true)
    private String extraData = null;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="\"GCS_Class\"")
    private GeocodeSystem taxonomyClass;
    @ManyToOne
    @JoinColumn(name="\"GCS_Creator\"", nullable=false)
    private Principal creator = null;

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean getIsUserTaxonomy() {
        return this.isUserTaxonomy != 0;
    }

    public void setIsUserTaxonomy(boolean isUserTaxonomy) {
        this.isUserTaxonomy = (short)(isUserTaxonomy ? 1 : 0);
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public void setExtraData(String extraData) {
        this.extraData = extraData;
    }

    public String getExtraData() {
        return this.extraData;
    }

    public boolean getIsActive() {
        if (this.isActive == null) {
            return true;
        }
        return this.isActive != 0;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = (short)(isActive ? 1 : 0);
    }

    public Principal getCreator() {
        return this.creator;
    }

    public void setCreator(Principal creator) {
        this.creator = creator;
    }

    public GeocodeSystem getTaxonomyClass() {
        return this.taxonomyClass;
    }

    public void setTaxonomyClass(GeocodeSystem taxonomy) {
        this.taxonomyClass = taxonomy;
    }

    public String toString() {
        return "Taxonomy(id=" + this.getId() + " name=" + this.getName() + " isUserTaxonomy=" + this.getIsUserTaxonomy() + " taxonomyClass=" + this.getTaxonomyClass() + " isActive=" + this.getIsActive() + " creation=" + this.getCreationDate() + " lastUpdate=" + this.getLastUpdate() + " creator=" + (this.creator != null ? this.creator.getId() : null);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        return this.id.equals(((GeocodeSystem)other).getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

