/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.layer;

import gr.cite.geoanalytics.dataaccess.entities.layer.DataSource;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.SysConfigData;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.layer.LayerBounds;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

@XmlRootElement
@XmlSeeAlso(value={LayerBounds.class})
public class LayerConfig
implements SysConfigData {
    private String name = null;
    private String layerId = null;
    private String style = null;
    @Enumerated(value=EnumType.STRING)
    private DataSource dataSource = null;
    private Integer minScale = null;
    private Integer maxScale = null;
    private LayerBounds boundingBox;

    public LayerConfig() {
    }

    public LayerConfig(LayerConfig other) {
        this.name = other.name;
        this.layerId = other.layerId;
        this.minScale = other.minScale;
        this.maxScale = other.maxScale;
        this.style = other.style;
        this.boundingBox = new LayerBounds(other.boundingBox);
        this.dataSource = other.dataSource;
    }

    public String getStyle() {
        return this.style;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @XmlElement
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @XmlElement
    public void setStyle(String style) {
        this.style = style;
    }

    public String getName() {
        return this.name;
    }

    @XmlElement
    public void setName(String name) {
        this.name = name;
    }

    public Integer getMinScale() {
        return this.minScale;
    }

    @XmlElement
    public void setMinScale(Integer minScale) {
        this.minScale = minScale;
    }

    public Integer getMaxScale() {
        return this.maxScale;
    }

    @XmlElement
    public void setMaxScale(Integer maxScale) {
        this.maxScale = maxScale;
    }

    public LayerBounds getBoundingBox() {
        return this.boundingBox;
    }

    @XmlElement(name="bounds")
    public void setBoundingBox(LayerBounds boundingBox) {
        this.boundingBox = boundingBox;
    }

    public String getLayerId() {
        return this.layerId;
    }

    @XmlElement
    public void setLayerId(String layerId) {
        this.layerId = layerId;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        return this.layerId.equals(((LayerConfig)other).getLayerId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        if (this.minScale != null) {
            sb.append(" minScale: " + this.minScale);
        }
        if (this.maxScale != null) {
            sb.append(" maxScale: " + this.maxScale);
        }
        if (this.boundingBox != null) {
            sb.append(" bbox: (" + this.boundingBox.toString() + ")");
        }
        if (this.layerId != null) {
            sb.append(" termId: " + this.layerId);
        }
        if (this.style != null) {
            sb.append(" style: " + this.style);
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

