/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.memory.CollectionSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapLayer;
import org.geotools.map.FeatureLayer;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.GridReaderLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.map.MapViewport;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DefaultMapContext
extends MapContext {
    public DefaultMapContext() {
        super((CoordinateReferenceSystem)null);
    }

    public DefaultMapContext(CoordinateReferenceSystem crs) {
        super(null, null, null, null, null, crs);
    }

    public DefaultMapContext(MapLayer[] layers) {
        super(layers, DefaultGeographicCRS.WGS84);
    }

    public DefaultMapContext(MapLayer[] layers, CoordinateReferenceSystem crs) {
        super(layers, null, null, null, null, crs);
    }

    public DefaultMapContext(MapLayer[] layers, String title, String contextAbstract, String contactInformation, String[] keywords) {
        super(layers, title, contextAbstract, contactInformation, keywords, null);
    }

    public DefaultMapContext(MapLayer[] layers, String title, String contextAbstract, String contactInformation, String[] keywords, CoordinateReferenceSystem crs) {
        super(layers, title, contextAbstract, contactInformation, keywords, crs);
    }

    @Override
    public boolean addLayer(int index, MapLayer mapLayer) {
        Layer layer = mapLayer.toLayer();
        this.layers().add(index, layer);
        return true;
    }

    @Override
    public boolean addLayer(MapLayer mapLayer) {
        this.layers().add(mapLayer.toLayer());
        return true;
    }

    @Override
    public void addLayer(FeatureSource featureSource, Style style) {
        Style layerStyle = this.checkStyle(style, (FeatureType)featureSource.getSchema());
        this.addLayer(new DefaultMapLayer(featureSource, layerStyle, ""));
    }

    public void addLayer(CollectionSource source, Style style) {
        throw new UnsupportedOperationException("FeatureSource required");
    }

    @Override
    public void addLayer(GridCoverage gc, Style style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null");
        }
        if (!(gc instanceof GridCoverage2D)) {
            throw new UnsupportedOperationException("GridCoverage2D required");
        }
        GridCoverageLayer layer = new GridCoverageLayer((GridCoverage2D)gc, style);
        this.layers().add(layer);
    }

    @Override
    public void addLayer(GridCoverage2DReader reader, Style style) {
        if (style == null) {
            throw new IllegalArgumentException("Style cannot be null");
        }
        GridReaderLayer layer = new GridReaderLayer(reader, style);
        this.layers().add(layer);
    }

    @Override
    public void addLayer(FeatureCollection featureCollection, Style style) {
        Object schema = featureCollection.getSchema();
        Style layerStyle = this.checkStyle(style, (FeatureType)schema);
        FeatureLayer layer = new FeatureLayer(featureCollection, layerStyle);
        this.layers().add(layer);
    }

    @Override
    public void addLayer(Collection collection, Style style) {
        if (!(collection instanceof FeatureCollection)) {
            throw new IllegalArgumentException("FeatureCollection required");
        }
        FeatureCollection featureCollection = (FeatureCollection)((Object)collection);
        this.addLayer(featureCollection, style);
    }

    private Style checkStyle(Style style, FeatureType featureType) {
        if (style != null) {
            return style;
        }
        Style defaultStyle = SLD.createSimpleStyle(featureType);
        if (defaultStyle == null) {
            throw new IllegalStateException("Failed to creaate a default style for the layer");
        }
        return defaultStyle;
    }

    @Override
    public boolean removeLayer(MapLayer layer) {
        int index = this.indexOf(layer);
        if (index == -1) {
            return false;
        }
        this.removeLayer(index);
        return true;
    }

    @Override
    public MapLayer removeLayer(int index) {
        Layer removed = this.layers().remove(index);
        return new DefaultMapLayer(removed);
    }

    @Override
    public int addLayers(MapLayer[] array) {
        if (array == null || array.length == 0) {
            return 0;
        }
        return super.addLayers(this.toLayerList(array));
    }

    @Override
    public void removeLayers(MapLayer[] array) {
        if (array == null || array.length == 0 || this.layers().isEmpty()) {
            return;
        }
        List<Layer> layersToRemove = this.toLayerList(array);
        this.layers().removeAll(layersToRemove);
    }

    @Override
    public MapLayer[] getLayers() {
        MapLayer[] array = new MapLayer[this.layers().size()];
        int index = 0;
        for (Layer layer : this.layers()) {
            array[index] = new DefaultMapLayer(layer);
            ++index;
        }
        return array;
    }

    @Override
    public MapLayer getLayer(int index) throws IndexOutOfBoundsException {
        Layer layer = this.layers().get(index);
        return new DefaultMapLayer(layer);
    }

    @Override
    public void clearLayerList() {
        this.layers().clear();
    }

    @Override
    public synchronized MapViewport getViewport() {
        if (this.viewport == null) {
            this.viewport = new MapViewport();
            try {
                ReferencedEnvelope layerBounds = this.getLayerBounds();
                if (layerBounds != null) {
                    this.viewport.setBounds(layerBounds);
                    this.viewport.setCoordinateReferenceSystem(layerBounds.getCoordinateReferenceSystem());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.viewport;
    }
}

