/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;

public class EckertIV
extends MapProjection {
    private static final long serialVersionUID = 1635471013603509976L;
    private static final double C_x = 0.4222382003157712;
    private static final double C_y = 1.3265004281770023;
    private static final double C_p = 3.5707963267948966;
    private static final double RC_p = 0.2800495767557787;
    private static final double EPS = 1.0E-7;
    private static final int NITER = 6;

    protected EckertIV(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    @Override
    protected Point2D transformNormalized(double lam, double phi, Point2D ptDst) throws ProjectionException {
        int i;
        double p = 3.5707963267948966 * Math.sin(phi);
        double V = phi * phi;
        phi *= 0.895168 + V * (0.0218849 + V * 0.00826809);
        for (i = 6; i > 0; --i) {
            double c = Math.cos(phi);
            double s = Math.sin(phi);
            V = (phi + s * (c + 2.0) - p) / (1.0 + c * (c + 2.0) - s * s);
            phi -= V;
            if (Math.abs(V) < 1.0E-7) break;
        }
        if (ptDst == null) {
            ptDst = new Point2D.Double();
        }
        if (i == 0) {
            ptDst.setLocation(0.4222382003157712 * lam, phi < 0.0 ? -1.3265004281770023 : 1.3265004281770023);
        } else {
            ptDst.setLocation(0.4222382003157712 * lam * (1.0 + Math.cos(phi)), 1.3265004281770023 * Math.sin(phi));
        }
        return ptDst;
    }

    @Override
    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double phi = this.aasin(y / 1.3265004281770023);
        double c = Math.cos(phi);
        double lam = x / (0.4222382003157712 * (1.0 + c));
        phi = this.aasin((phi + Math.sin(phi) * (c + 2.0)) / 3.5707963267948966);
        if (ptDst == null) {
            ptDst = new Point2D.Double();
        }
        ptDst.setLocation(lam, phi);
        return ptDst;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return super.equals(object);
    }

    @Override
    protected double getToleranceForAssertions(double longitude, double latitude) {
        return 2.0;
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = 1136453952351519284L;
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.GEOTOOLS, "Eckert_IV"), new NamedIdentifier(Citations.ESRI, "Eckert_IV")}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN});

        public Provider() {
            super(PARAMETERS);
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            parameters.parameter("semi_minor").setValue(parameters.parameter("semi_major").getValue());
            return new EckertIV(parameters);
        }
    }
}

