/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.sld.bindings;

import javax.xml.namespace.QName;
import org.geotools.filter.Filters;
import org.geotools.sld.CssParameter;
import org.geotools.sld.bindings.SLD;
import org.geotools.styling.Graphic;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleFactory;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.picocontainer.MutablePicoContainer;

public class SLDStrokeBinding
extends AbstractComplexBinding {
    StyleFactory styleFactory;
    FilterFactory filterFactory;

    public SLDStrokeBinding(StyleFactory styleFactory, FilterFactory filterFactory) {
        this.styleFactory = styleFactory;
        this.filterFactory = filterFactory;
    }

    @Override
    public QName getTarget() {
        return SLD.STROKE;
    }

    @Override
    public int getExecutionMode() {
        return 0;
    }

    @Override
    public Class getType() {
        return Stroke.class;
    }

    @Override
    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        Expression color = null;
        Expression opacity = null;
        Expression width = null;
        Expression lineJoin = null;
        Expression lineCap = null;
        Expression dashArray = null;
        Expression dashOffset = null;
        for (CssParameter css : node.getChildValues(CssParameter.class)) {
            Expression exp = css.getExpression();
            if (exp == null) continue;
            if ("stroke".equals(css.getName())) {
                color = exp;
                continue;
            }
            if ("stroke-opacity".equals(css.getName())) {
                opacity = exp;
                continue;
            }
            if ("stroke-width".equals(css.getName())) {
                width = exp;
                continue;
            }
            if ("stroke-linejoin".equals(css.getName())) {
                lineJoin = exp;
                continue;
            }
            if ("stroke-linecap".equals(css.getName())) {
                lineCap = exp;
                continue;
            }
            if ("stroke-dasharray".equals(css.getName())) {
                dashArray = exp;
                continue;
            }
            if (!"stroke-dashoffset".equals(css.getName())) continue;
            dashOffset = exp;
        }
        float[] dash = null;
        if (dashArray != null) {
            String[] string = Filters.asString(dashArray).split(" +");
            dash = new float[string.length];
            for (int i = 0; i < string.length; ++i) {
                dash[i] = Float.parseFloat(string[i]);
            }
        }
        Graphic graphicFill = (Graphic)node.getChildValue("GraphicFill");
        Graphic graphicStroke = (Graphic)node.getChildValue("GraphicStroke");
        return this.styleFactory.createStroke(color, width, opacity, lineJoin, lineCap, dash, dashOffset, graphicFill, graphicStroke);
    }
}

