/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.ecql;

import org.geotools.filter.text.commons.BuildResultStack;
import org.geotools.filter.text.cql2.CQLException;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

class SpatialOperationBuilder {
    private final BuildResultStack resultStack;
    private final FilterFactory2 filterFactory;

    public SpatialOperationBuilder(BuildResultStack resultStack, FilterFactory filterFactory) {
        assert (resultStack != null);
        assert (filterFactory != null);
        this.resultStack = resultStack;
        this.filterFactory = (FilterFactory2)filterFactory;
    }

    protected final BuildResultStack getResultStack() {
        return this.resultStack;
    }

    protected final FilterFactory2 getFilterFactory() {
        return this.filterFactory;
    }

    private Expression[] buildParameters() throws CQLException {
        Expression[] params = new Expression[2];
        params[1] = this.resultStack.popExpression();
        params[0] = this.resultStack.popExpression();
        return params;
    }

    protected BinarySpatialOperator buildFilter(Expression expr1, Expression expr2) {
        throw new UnsupportedOperationException("must be implemented");
    }

    protected Contains buildContains() throws CQLException {
        Expression[] params = this.buildParameters();
        return this.getFilterFactory().contains(params[0], params[1]);
    }

    public Equals buildEquals() throws CQLException {
        Expression[] params = this.buildParameters();
        return this.getFilterFactory().equal(params[0], params[1]);
    }

    public Disjoint buildDisjoint() throws CQLException {
        Expression[] params = this.buildParameters();
        return this.getFilterFactory().disjoint(params[0], params[1]);
    }

    public Intersects buildIntersects() throws CQLException {
        Expression[] params = this.buildParameters();
        return this.getFilterFactory().intersects(params[0], params[1]);
    }

    public Touches buildTouches() throws CQLException {
        Expression[] params = this.buildParameters();
        return this.getFilterFactory().touches(params[0], params[1]);
    }

    public Crosses buildCrosses() throws CQLException {
        Expression[] params = this.buildParameters();
        return this.getFilterFactory().crosses(params[0], params[1]);
    }

    public Within buildWithin() throws CQLException {
        Expression[] params = this.buildParameters();
        return this.getFilterFactory().within(params[0], params[1]);
    }

    public Overlaps buildOverlaps() throws CQLException {
        Expression[] params = this.buildParameters();
        return this.getFilterFactory().overlaps(params[0], params[1]);
    }

    public BBOX buildBBoxWithCRS() throws CQLException {
        String crs = this.getResultStack().popStringValue();
        assert (crs != null);
        BBOX bbox = this.buildBBox(crs);
        return bbox;
    }

    public BBOX buildBBox() throws CQLException {
        BBOX bbox = this.buildBBox(null);
        return bbox;
    }

    private BBOX buildBBox(String crs) throws CQLException {
        double maxY = this.getResultStack().popDoubleValue();
        double maxX = this.getResultStack().popDoubleValue();
        double minY = this.getResultStack().popDoubleValue();
        double minX = this.getResultStack().popDoubleValue();
        Expression expr = this.getResultStack().popExpression();
        FilterFactory2 ff = this.getFilterFactory();
        BBOX bbox = ff.bbox(expr, minX, minY, maxX, maxY, crs);
        return bbox;
    }
}

