/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.environmental.data.retriever;

import gr.cite.geoanalytics.environmental.data.retriever.utils.ResourceUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DateResourceResolver {
    TreeMap<Integer, Map<Integer, TreeMap<Integer, String>>> dateToResource = new TreeMap();

    public DateResourceResolver(String folder, String suffix) throws Exception {
        try {
            Map<String, String> resourceNames = ResourceUtils.getResourcesNames(folder, suffix);
            resourceNames.entrySet().forEach(e -> this.addDateResourcePair((String)e.getKey(), (String)e.getValue()));
        }
        catch (Exception e2) {
            throw new Exception("Could not initialize resources", e2);
        }
    }

    public String getResourceFromDate(String date) {
        String[] tokens = date.split("-");
        int day = Integer.parseInt(tokens[0]);
        int month = Integer.parseInt(tokens[1]);
        int year = Integer.parseInt(tokens[2]);
        Integer ceilKey = this.dateToResource.ceilingKey(year);
        Integer floorKey = this.dateToResource.floorKey(year);
        if (ceilKey != null && floorKey != null) {
            int floorDistance = year - floorKey;
            int ceilDistance = ceilKey - year;
            if (ceilDistance < floorDistance) {
                return this.dateToResource.ceilingEntry(year).getValue().get(month).ceilingEntry(day).getValue();
            }
            return this.dateToResource.floorEntry(year).getValue().get(month).ceilingEntry(day).getValue();
        }
        if (ceilKey != null) {
            return this.dateToResource.ceilingEntry(year).getValue().get(month).ceilingEntry(day).getValue();
        }
        return this.dateToResource.floorEntry(year).getValue().get(month).ceilingEntry(day).getValue();
    }

    public void addDateResourcePair(String date, String resourcePath) {
        String[] tokens = date.split("-");
        int day = Integer.parseInt(tokens[0]);
        int month = Integer.parseInt(tokens[1]);
        int year = Integer.parseInt(tokens[2]);
        if (!this.dateToResource.containsKey(year)) {
            this.dateToResource.put(year, new HashMap());
        }
        if (!this.dateToResource.get(year).containsKey(month)) {
            this.dateToResource.get(year).put(month, new TreeMap());
        }
        this.dateToResource.get(year).get(month).put(day, resourcePath);
    }

    public List<String> getAllDates() {
        ArrayList<String> results = new ArrayList<String>();
        for (Map.Entry<Integer, Map<Integer, TreeMap<Integer, String>>> yearToMonth : this.dateToResource.entrySet()) {
            int year = yearToMonth.getKey();
            for (Map.Entry<Integer, TreeMap<Integer, String>> monthToDay : yearToMonth.getValue().entrySet()) {
                int month = monthToDay.getKey();
                for (Map.Entry<Integer, String> dayToResource : monthToDay.getValue().entrySet()) {
                    int day = dayToResource.getKey();
                    results.add(day + "-" + month + "-" + year);
                }
            }
        }
        return results;
    }

    public List<String> getAllResourceNames() {
        ArrayList<String> results = new ArrayList<String>();
        for (Map.Entry<Integer, Map<Integer, TreeMap<Integer, String>>> yearToMonth : this.dateToResource.entrySet()) {
            for (Map.Entry<Integer, TreeMap<Integer, String>> monthToDay : yearToMonth.getValue().entrySet()) {
                results.addAll(monthToDay.getValue().values());
            }
        }
        return results;
    }
}

