/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs.v2_0.bindings;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class ConvertToDomHandler
extends DefaultHandler {
    Document doc;
    Node node;
    NamespaceSupport nsContext;

    public ConvertToDomHandler(Document doc, NamespaceSupport nsContext) {
        this.doc = doc;
        this.node = doc;
        this.nsContext = nsContext;
    }

    public Document getDocument() {
        return this.doc;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        this.nsContext.pushContext();
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attQName = attrs.getQName(i);
            if (!attQName.startsWith("xmlns")) continue;
            String prefix = attQName.length() > 5 ? attQName.substring(6) : "";
            this.nsContext.declarePrefix(prefix, attrs.getValue(i));
        }
        uri = this.namespace(qName);
        Element e = this.doc.createElementNS(uri, qName);
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attQName = attrs.getQName(i);
            if (attQName.startsWith("xmlns")) continue;
            String attUri = this.namespace(attQName);
            Attr a = this.doc.createAttributeNS(attUri, attQName);
            a.setValue(attrs.getValue(i));
            e.setAttributeNodeNS(a);
        }
        this.node.appendChild(e);
        this.node = e;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String str = new String(ch, start, length);
        Text text = this.doc.createTextNode(str);
        this.node.appendChild(text);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.node = this.node.getParentNode();
        this.nsContext.popContext();
    }

    String namespace(String qName) {
        String[] split = qName.split(":");
        if (split.length > 1) {
            return this.nsContext.getURI(split[0]);
        }
        return this.nsContext.getURI("");
    }
}

