/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.simple;

import org.ejml.UtilEjml;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.SingularOps;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;

public class SimpleSVD<T extends SimpleMatrix> {
    private SingularValueDecomposition<DenseMatrix64F> svd;
    private T U;
    private T W;
    private T V;
    private DenseMatrix64F mat;

    public SimpleSVD(DenseMatrix64F mat, boolean compact) {
        this.mat = mat;
        this.svd = DecompositionFactory.svd(mat.numRows, mat.numCols, true, true, compact);
        if (!this.svd.decompose(mat)) {
            throw new RuntimeException("Decomposition failed");
        }
        this.U = SimpleMatrix.wrap(this.svd.getU(null, false));
        this.W = SimpleMatrix.wrap(this.svd.getW(null));
        this.V = SimpleMatrix.wrap(this.svd.getV(null, false));
        SingularOps.descendingOrder(((SimpleBase)this.U).getMatrix(), false, ((SimpleBase)this.W).getMatrix(), ((SimpleBase)this.V).getMatrix(), false);
    }

    public T getU() {
        return this.U;
    }

    public T getW() {
        return this.W;
    }

    public T getV() {
        return this.V;
    }

    public double quality() {
        return DecompositionFactory.quality(this.mat, ((SimpleBase)this.U).getMatrix(), ((SimpleBase)this.W).getMatrix(), ((SimpleMatrix)((SimpleBase)this.V).transpose()).getMatrix());
    }

    public SimpleMatrix nullSpace() {
        return SimpleMatrix.wrap(SingularOps.nullSpace(this.svd, null, UtilEjml.EPS));
    }

    public double getSingleValue(int index) {
        return ((SimpleBase)this.W).get(index, index);
    }

    public int rank() {
        return SingularOps.rank(this.svd, 10.0 * UtilEjml.EPS);
    }

    public int nullity() {
        return SingularOps.nullity(this.svd, 10.0 * UtilEjml.EPS);
    }

    public SingularValueDecomposition getSVD() {
        return this.svd;
    }
}

