/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.wfs20;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ResolveValueType implements Enumerator
{
    LOCAL(0, "local", "local"),
    REMOTE(1, "remote", "remote"),
    ALL(2, "all", "all"),
    NONE(3, "none", "none");

    public static final int LOCAL_VALUE = 0;
    public static final int REMOTE_VALUE = 1;
    public static final int ALL_VALUE = 2;
    public static final int NONE_VALUE = 3;
    private static final ResolveValueType[] VALUES_ARRAY;
    public static final List<ResolveValueType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ResolveValueType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ResolveValueType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ResolveValueType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ResolveValueType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ResolveValueType get(int value) {
        switch (value) {
            case 0: {
                return LOCAL;
            }
            case 1: {
                return REMOTE;
            }
            case 2: {
                return ALL;
            }
            case 3: {
                return NONE;
            }
        }
        return null;
    }

    private ResolveValueType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ResolveValueType[]{LOCAL, REMOTE, ALL, NONE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

