/*
 * Decompiled with CFR 0.152.
 */
package net.sf.geographiclib;

import net.sf.geographiclib.Pair;

public class GeoMath {
    public static final int digits = 53;
    public static final double epsilon = Math.pow(0.5, 52.0);
    public static final double min = Math.pow(0.5, 1022.0);
    public static final double degree = Math.PI / 180;

    public static double sq(double x) {
        return x * x;
    }

    public static double hypot(double x, double y) {
        x = Math.abs(x);
        y = Math.abs(y);
        double a = Math.max(x, y);
        double b = Math.min(x, y) / (a != 0.0 ? a : 1.0);
        return a * Math.sqrt(1.0 + b * b);
    }

    public static double log1p(double x) {
        double y = 1.0 + x;
        double z = y - 1.0;
        return z == 0.0 ? x : x * Math.log(y) / z;
    }

    public static double atanh(double x) {
        double y = Math.abs(x);
        y = Math.log1p(2.0 * y / (1.0 - y)) / 2.0;
        return x < 0.0 ? -y : y;
    }

    public static double cbrt(double x) {
        double y = Math.pow(Math.abs(x), 0.3333333333333333);
        return x < 0.0 ? -y : y;
    }

    public static Pair norm(double sinx, double cosx) {
        double r = GeoMath.hypot(sinx, cosx);
        return new Pair(sinx / r, cosx / r);
    }

    public static Pair sum(double u, double v) {
        double s = u + v;
        double up = s - v;
        double vpp = s - up;
        double t = -((up -= u) + (vpp -= v));
        return new Pair(s, t);
    }

    public static double polyval(int N, double[] p, int s, double x) {
        double y;
        double d = y = N < 0 ? 0.0 : p[s++];
        while (--N >= 0) {
            y = y * x + p[s++];
        }
        return y;
    }

    public static double AngRound(double x) {
        double z = 0.0625;
        double y = Math.abs(x);
        y = y < 0.0625 ? 0.0625 - (0.0625 - y) : y;
        return x < 0.0 ? 0.0 - y : y;
    }

    public static double AngNormalize(double x) {
        return (x %= 360.0) < -180.0 ? x + 360.0 : (x < 180.0 ? x : x - 360.0);
    }

    public static double LatFix(double x) {
        return Math.abs(x) > 90.0 ? Double.NaN : x;
    }

    public static double AngDiff(double x, double y) {
        Pair r = GeoMath.sum(GeoMath.AngNormalize(x), GeoMath.AngNormalize(-y));
        double d = -GeoMath.AngNormalize(r.first);
        double t = r.second;
        return (d == 180.0 && t < 0.0 ? -180.0 : d) - t;
    }

    public static Pair sincosd(double x) {
        double cosx;
        double sinx;
        double r = x % 360.0;
        int q = (int)Math.floor(r / 90.0 + 0.5);
        r -= (double)(90 * q);
        double s = Math.sin(r *= Math.PI / 180);
        double c = Math.cos(r);
        switch (q & 3) {
            case 0: {
                sinx = s;
                cosx = c;
                break;
            }
            case 1: {
                sinx = c;
                cosx = 0.0 - s;
                break;
            }
            case 2: {
                sinx = 0.0 - s;
                cosx = 0.0 - c;
                break;
            }
            default: {
                sinx = 0.0 - c;
                cosx = s;
            }
        }
        return new Pair(sinx, cosx);
    }

    public static double atan2d(double y, double x) {
        int q = 0;
        if (Math.abs(y) > Math.abs(x)) {
            double t = x;
            x = y;
            y = t;
            q = 2;
        }
        if (x < 0.0) {
            x = -x;
            ++q;
        }
        double ang = Math.atan2(y, x) / (Math.PI / 180);
        switch (q) {
            case 1: {
                ang = (double)(y > 0.0 ? 180 : -180) - ang;
                break;
            }
            case 2: {
                ang = 90.0 - ang;
                break;
            }
            case 3: {
                ang = -90.0 + ang;
            }
        }
        return ang;
    }

    public static boolean isfinite(double x) {
        return Math.abs(x) <= Double.MAX_VALUE;
    }

    private GeoMath() {
    }
}

