/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.HashMap;
import java.util.Map;
import org.geotools.filter.capability.ArithmeticOperatorsImpl;
import org.geotools.filter.capability.ComparisonOperatorsImpl;
import org.geotools.filter.capability.FilterCapabilitiesImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.capability.FunctionsImpl;
import org.geotools.filter.capability.OperatorImpl;
import org.geotools.filter.capability.SpatialOperatorImpl;
import org.geotools.filter.capability.SpatialOperatorsImpl;
import org.geotools.filter.visitor.IsFullySupportedFilterVisitor;
import org.geotools.filter.visitor.IsSupportedFilterVisitor;
import org.geotools.filter.visitor.OperatorNameFilterVisitor;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.capability.FilterCapabilities;
import org.opengis.filter.capability.GeometryOperand;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class Capabilities {
    private static Map<Class<?>, String> scalarNames = new HashMap();
    private static Map<Class<?>, String> spatialNames;
    private static Map<Class<?>, String> logicalNames;
    private static Map<Class<?>, String> filterNames;
    private static Map<Class<? extends Expression>, String> arithmaticNames;
    private static Map<Class<? extends Expression>, String> exprNames;
    private static final OperatorNameFilterVisitor operationNameVisitor;
    public static Capabilities LOGICAL;
    public static Capabilities LOGICAL_OPENGIS;
    public static Capabilities SIMPLE_COMPARISONS;
    public static Capabilities SIMPLE_COMPARISONS_OPENGIS;
    IsSupportedFilterVisitor supportedVisitor;
    IsFullySupportedFilterVisitor fullySupportedVisitor;
    FilterCapabilitiesImpl contents;

    public Capabilities() {
        this(new FilterCapabilitiesImpl());
    }

    public Capabilities(FilterCapabilities contents) {
        this.contents = contents instanceof FilterCapabilitiesImpl ? (FilterCapabilitiesImpl)contents : new FilterCapabilitiesImpl(contents);
        this.supportedVisitor = new IsSupportedFilterVisitor(contents);
        this.fullySupportedVisitor = new IsFullySupportedFilterVisitor(contents);
    }

    public FilterCapabilitiesImpl getContents() {
        return this.contents;
    }

    public void addType(Class type) {
        String name = this.toOperationName(type);
        if (name == null) {
            return;
        }
        this.addName(name);
    }

    public void addName(String name) {
        if (name == null) {
            return;
        }
        if (spatialNames.containsValue(name)) {
            SpatialOperatorsImpl operators = this.contents.getSpatialCapabilities().getSpatialOperators();
            if (operators.getOperator(name) == null) {
                SpatialOperatorImpl operator = new SpatialOperatorImpl(name);
                operator.getGeometryOperands().add(GeometryOperand.LineString);
                operator.getGeometryOperands().add(GeometryOperand.Point);
                operator.getGeometryOperands().add(GeometryOperand.Polygon);
                operators.getOperators().add(operator);
            }
        } else if (scalarNames.containsValue(name)) {
            ComparisonOperatorsImpl operators = this.contents.getScalarCapabilities().getComparisonOperators();
            if (operators.getOperator(name) == null) {
                OperatorImpl operator = new OperatorImpl(name);
                operators.getOperators().add(operator);
            }
        } else if (arithmaticNames.containsValue(name)) {
            ArithmeticOperatorsImpl operators = this.contents.getScalarCapabilities().getArithmeticOperators();
            operators.setSimpleArithmetic(true);
        } else if (logicalNames.containsValue(name)) {
            this.contents.getScalarCapabilities().setLogicalOperators(true);
        } else if ("Id".equals(name)) {
            this.contents.getIdCapabilities().setFID(true);
        } else {
            FunctionsImpl functions = this.contents.getScalarCapabilities().getArithmeticOperators().getFunctions();
            if (functions.getFunctionName(name) == null) {
                FunctionNameImpl function = new FunctionNameImpl(name, 0);
                functions.getFunctionNames().add(function);
            }
        }
    }

    public void addName(String name, int argumentCount) {
        FunctionsImpl functions = this.contents.getScalarCapabilities().getArithmeticOperators().getFunctions();
        if (functions.getFunctionName(name) == null) {
            FunctionNameImpl function = new FunctionNameImpl(name, argumentCount);
            functions.getFunctionNames().add(function);
        }
    }

    public void addName(String name, String ... argumentNames) {
        FunctionsImpl functions = this.contents.getScalarCapabilities().getArithmeticOperators().getFunctions();
        if (functions.getFunctionName(name) == null) {
            FunctionNameImpl function = new FunctionNameImpl(name, argumentNames);
            functions.getFunctionNames().add(function);
        }
    }

    public boolean supports(Filter filter) {
        if (filter == null) {
            return false;
        }
        if (this.supportedVisitor == null) {
            this.supportedVisitor = new IsSupportedFilterVisitor(this.contents);
        }
        return (Boolean)filter.accept(this.supportedVisitor, null);
    }

    public boolean fullySupports(Filter filter) {
        if (filter == null) {
            return false;
        }
        if (this.fullySupportedVisitor == null) {
            this.fullySupportedVisitor = new IsFullySupportedFilterVisitor(this.contents);
        }
        return (Boolean)filter.accept(this.fullySupportedVisitor, null);
    }

    public boolean fullySupports(Expression expression) {
        if (expression == null) {
            return false;
        }
        if (this.fullySupportedVisitor == null) {
            this.fullySupportedVisitor = new IsFullySupportedFilterVisitor(this.contents);
        }
        return (Boolean)expression.accept(this.fullySupportedVisitor, null);
    }

    public String toOperationName(Filter filter) {
        if (filter == null) {
            return null;
        }
        return (String)filter.accept(operationNameVisitor, null);
    }

    public String toOperationName(Class filterType) {
        if (filterType == null) {
            return null;
        }
        String quick = filterNames.get(filterType);
        if (quick != null) {
            return quick;
        }
        for (Map.Entry<Class<?>, String> mapping : filterNames.entrySet()) {
            if (!mapping.getKey().isAssignableFrom(filterType)) continue;
            return mapping.getValue();
        }
        return null;
    }

    public void addAll(Capabilities copy) {
        this.addAll(copy.getContents());
    }

    public void addAll(FilterCapabilities copy) {
        this.contents.addAll(copy);
    }

    static {
        scalarNames.put(PropertyIsEqualTo.class, "EqualTo");
        scalarNames.put(PropertyIsNotEqualTo.class, "NotEqualTo");
        scalarNames.put(PropertyIsGreaterThan.class, "GreaterThan");
        scalarNames.put(PropertyIsGreaterThanOrEqualTo.class, "GreaterThanOrEqualTo");
        scalarNames.put(PropertyIsLessThan.class, "LessThan");
        scalarNames.put(PropertyIsLessThanOrEqualTo.class, "LessThanOrEqualTo");
        scalarNames.put(PropertyIsNull.class, "NullCheck");
        scalarNames.put(PropertyIsLike.class, "Like");
        scalarNames.put(PropertyIsBetween.class, "Between");
        spatialNames = new HashMap();
        spatialNames.put(BBOX.class, "BBOX");
        spatialNames.put(Equals.class, "Equals");
        spatialNames.put(Disjoint.class, "Disjoint");
        spatialNames.put(Intersects.class, "Intersects");
        spatialNames.put(Touches.class, "Touches");
        spatialNames.put(Crosses.class, "Crosses");
        spatialNames.put(Within.class, "Within");
        spatialNames.put(Contains.class, "Contains");
        spatialNames.put(Overlaps.class, "Overlaps");
        spatialNames.put(Beyond.class, "Beyond");
        spatialNames.put(DWithin.class, "DWithin");
        logicalNames = new HashMap();
        logicalNames.put(And.class, "And");
        logicalNames.put(Or.class, "Or");
        logicalNames.put(Not.class, "Not");
        filterNames = new HashMap();
        filterNames.putAll(scalarNames);
        filterNames.putAll(spatialNames);
        filterNames.putAll(logicalNames);
        filterNames.put(Id.class, "Id");
        arithmaticNames = new HashMap<Class<? extends Expression>, String>();
        arithmaticNames.put(Add.class, "Add");
        arithmaticNames.put(Subtract.class, "Sub");
        arithmaticNames.put(Multiply.class, "Mul");
        arithmaticNames.put(Divide.class, "Div");
        exprNames = new HashMap<Class<? extends Expression>, String>();
        exprNames.putAll(arithmaticNames);
        exprNames.put(Function.class, "Function");
        operationNameVisitor = new OperatorNameFilterVisitor();
        LOGICAL = new Capabilities();
        LOGICAL.addType(And.class);
        LOGICAL.addType(Not.class);
        LOGICAL.addType(Or.class);
        LOGICAL_OPENGIS = LOGICAL;
        SIMPLE_COMPARISONS = new Capabilities();
        SIMPLE_COMPARISONS.addType(PropertyIsEqualTo.class);
        SIMPLE_COMPARISONS.addType(PropertyIsGreaterThan.class);
        SIMPLE_COMPARISONS.addType(PropertyIsGreaterThanOrEqualTo.class);
        SIMPLE_COMPARISONS.addType(PropertyIsLessThan.class);
        SIMPLE_COMPARISONS.addType(PropertyIsLessThanOrEqualTo.class);
        SIMPLE_COMPARISONS.addType(PropertyIsNotEqualTo.class);
        SIMPLE_COMPARISONS_OPENGIS = SIMPLE_COMPARISONS;
    }
}

