/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.DelayedSchemaFeatureCollection;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.feature.simple.SimpleFeature;

public class AbstractFeatureCollectionTypeBinding
extends AbstractComplexBinding {
    @Override
    public QName getTarget() {
        return GML.AbstractFeatureCollectionType;
    }

    @Override
    public Class getType() {
        return FeatureCollection.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        SimpleFeatureCollection featureCollection = (SimpleFeatureCollection)node.getChildValue(FeatureCollection.class);
        if (featureCollection == null) {
            featureCollection = new DelayedSchemaFeatureCollection();
        }
        List childValues = node.getChildValues(SimpleFeature.class);
        Collection<SimpleFeature> collection = DataUtilities.collectionCast(featureCollection);
        collection.addAll(childValues);
        SimpleFeature[] featureMembers = (SimpleFeature[])node.getChildValue(SimpleFeature[].class);
        if (featureMembers != null) {
            for (int i = 0; i < featureMembers.length; ++i) {
                collection.add(featureMembers[i]);
            }
        }
        return featureCollection;
    }

    @Override
    public Object getProperty(Object object, QName name) {
        if (GML.featureMembers.equals(name)) {
            SimpleFeatureCollection fc = (SimpleFeatureCollection)object;
            return fc;
        }
        return null;
    }
}

