/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.geotools.factory.GeoTools;
import org.geotools.swing.dialog.AbstractSimpleDialog;

public class JAboutDialog
extends AbstractSimpleDialog {
    private static final int DEFAULT_HEIGHT = 400;
    private static final int LIST_WIDTH = 150;
    private static final int TEXT_AREA_WIDTH = 450;
    private final String applicationInfo;
    private final boolean hasApplicationInfo;
    private JList categoryList;
    private JTextArea textArea;

    public JAboutDialog() {
        this("About");
    }

    public JAboutDialog(String title) {
        this(title, null);
    }

    public JAboutDialog(String title, String applicationInfo) {
        super((JFrame)null, title, true, true);
        if (applicationInfo != null && applicationInfo.trim().length() > 0) {
            this.applicationInfo = applicationInfo;
            this.hasApplicationInfo = true;
        } else {
            this.applicationInfo = null;
            this.hasApplicationInfo = false;
        }
        this.initComponents();
        this.setDefaultCloseOperation(2);
    }

    @Override
    public JPanel createControlPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.categoryList = new JList(new CategoryListModel());
        this.categoryList.setPreferredSize(new Dimension(150, 400));
        this.categoryList.setBorder(BorderFactory.createTitledBorder("Categories"));
        this.categoryList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JAboutDialog.this.showInfo(JAboutDialog.this.categoryList.getSelectedIndex());
            }
        });
        panel.add((Component)this.categoryList, "West");
        this.textArea = new JTextArea();
        this.textArea.setPreferredSize(new Dimension(450, 400));
        this.textArea.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.textArea.setLineWrap(true);
        this.textArea.setEditable(false);
        panel.add((Component)this.textArea, "Center");
        this.categoryList.setSelectedIndex(0);
        return panel;
    }

    @Override
    public void onOK() {
        this.closeDialog();
    }

    @Override
    protected JPanel createButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(0, 5, 5));
        JButton copyBtn = new JButton("Copy to clipboard");
        copyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAboutDialog.this.copyToClipboard();
            }
        });
        panel.add(copyBtn);
        JButton okBtn = new JButton("Done");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAboutDialog.this.onOK();
            }
        });
        panel.add(okBtn);
        return panel;
    }

    private void showInfo(int index) {
        switch (Category.getByIndex(index, this.hasApplicationInfo)) {
            case APPLICATION: {
                this.showApplicationInfo();
                break;
            }
            case ENVIRONMENT: {
                this.showEnvironmentInfo();
                break;
            }
            case JARS: {
                this.showJarInfo();
                break;
            }
            case LICENCES: {
                this.showLicenceInfo();
                break;
            }
            case ALL: {
                this.showAllInfo();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Bad index value: " + index);
            }
        }
    }

    private void showApplicationInfo() {
        this.textArea.setText(this.applicationInfo);
    }

    private void showEnvironmentInfo() {
        this.textArea.setText(GeoTools.getEnvironmentInfo());
    }

    private void showLicenceInfo() {
        this.textArea.setText("This is the licence info");
    }

    private void showJarInfo() {
        this.textArea.setText(GeoTools.getGeoToolsJarInfo());
    }

    private void showAllInfo() {
        String newline = String.format("%n", new Object[0]);
        StringBuilder sb = new StringBuilder();
        if (this.hasApplicationInfo) {
            sb.append(this.applicationInfo).append(newline).append(newline);
        }
        sb.append(GeoTools.getEnvironmentInfo()).append(newline).append(newline);
        sb.append(GeoTools.getGeoToolsJarInfo()).append(newline).append(newline);
        sb.append("This is the licence info");
        this.textArea.setText(sb.toString());
    }

    private void copyToClipboard() {
        StringSelection sel = new StringSelection(this.textArea.getText());
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        clip.setContents(sel, sel);
    }

    private class CategoryListModel
    extends AbstractListModel {
        private CategoryListModel() {
        }

        @Override
        public int getSize() {
            return Category.values().length - (JAboutDialog.this.hasApplicationInfo ? 0 : 1);
        }

        @Override
        public Object getElementAt(int index) {
            return Category.getByIndex(index, JAboutDialog.this.hasApplicationInfo).toString();
        }
    }

    public static enum Category {
        APPLICATION("Application"),
        ENVIRONMENT("Environment"),
        LICENCES("Licences"),
        JARS("GeoTools jars"),
        ALL("All");

        private final String name;

        private Category(String name) {
            this.name = name;
        }

        public static Category getByIndex(int index, boolean hasApplicationInfo) {
            if (!hasApplicationInfo) {
                ++index;
            }
            return Category.values()[index];
        }

        public String toString() {
            return this.name;
        }
    }
}

