/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.process;

import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.geotools.process.ProcessFactory;
import org.geotools.process.Processors;
import org.geotools.swing.process.ProcessParameterPage;
import org.geotools.swing.wizard.JPage;
import org.opengis.feature.type.Name;
import org.opengis.util.InternationalString;

public class ProcessSelectionPage
extends JPage {
    Map<String, Object> input;
    JTree processList;
    Set<ProcessFactory> processFactories;
    JTextField descLabel;
    ProcessFactory selectedFactory;
    private Name selectedName;
    static final String defaultDesc = "Select a process to see its description";

    public ProcessSelectionPage() {
        this((Map<String, Object>)null);
    }

    public ProcessSelectionPage(Map<String, Object> input) {
        super("process selection");
        this.input = input;
        this.processFactories = Processors.getProcessFactories();
        this.selectedFactory = null;
    }

    @Override
    public String getBackPageIdentifier() {
        return null;
    }

    @Override
    public String getNextPageIdentifier() {
        if (this.selectedFactory == null) {
            return null;
        }
        ProcessParameterPage inputPage = new ProcessParameterPage(this.selectedFactory);
        this.getJWizard().registerWizardPanel(inputPage);
        return inputPage.getPageIdentifier();
    }

    public void aboutToDisplayPanel() {
        JPanel page = this.getPanel();
        page.removeAll();
        GridBagLayout gridBag = new GridBagLayout();
        page.setLayout(gridBag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.ipadx = 5;
        c.ipady = 5;
        JLabel title = new JLabel("Process Selection");
        title.setFont(new Font("Arial", 1, 14));
        c.gridx = 0;
        c.gridy = 0;
        gridBag.setConstraints(title, c);
        page.add(title);
        JLabel description = new JLabel("Select a Process and click 'Next'");
        description.setFont(new Font("Arial", 0, 11));
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.ipady = 20;
        gridBag.setConstraints(description, c);
        page.add(description);
        JLabel label1 = new JLabel("Process:");
        label1.setFont(new Font("Arial", 1, 12));
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.ipady = 5;
        gridBag.setConstraints(label1, c);
        page.add(label1);
        JLabel label2 = new JLabel("Process Description:");
        label2.setFont(new Font("Arial", 1, 12));
        c.gridx = 1;
        c.gridy = 2;
        gridBag.setConstraints(label2, c);
        page.add(label2);
        TreeModel data = this.createFactoryTitleArray(this.processFactories);
        this.processList = new JTree(data);
        this.processList.setFont(new Font("Arial", 0, 12));
        this.processList.getSelectionModel().setSelectionMode(1);
        this.processList.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getNewLeadSelectionPath();
                if (path.getLastPathComponent() instanceof Name) {
                    Name name = (Name)path.getLastPathComponent();
                    ProcessFactory factory = (ProcessFactory)path.getParentPath().getLastPathComponent();
                    ProcessSelectionPage.this.updateProcessDesc(factory, name);
                }
            }
        });
        c.gridx = 0;
        c.gridy = 3;
        gridBag.setConstraints(this.processList, c);
        page.add(this.processList);
        this.descLabel = new JTextField(defaultDesc, 35);
        this.descLabel.setEditable(false);
        LineBorder border = new LineBorder(this.getPanel().getBackground(), 0);
        this.descLabel.setBorder(border);
        this.descLabel.setFont(new Font("Arial", 0, 11));
        c.gridx = 1;
        c.gridy = 3;
        gridBag.setConstraints(this.descLabel, c);
        page.add(this.descLabel);
    }

    private TreeModel createFactoryTitleArray(Set<ProcessFactory> factories) {
        final ArrayList<ProcessFactory> root = new ArrayList<ProcessFactory>();
        final HashMap branch = new HashMap();
        root.addAll(factories);
        Collections.sort(root, new Comparator<ProcessFactory>(){

            @Override
            public int compare(ProcessFactory o1, ProcessFactory o2) {
                String s1 = o1.getTitle().toString();
                String s2 = o2.getTitle().toString();
                return s1.compareTo(s2);
            }
        });
        return new TreeModel(){

            @Override
            public Object getRoot() {
                return root;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            List<Name> getChildren(ProcessFactory factory) {
                ProcessFactory processFactory = factory;
                synchronized (processFactory) {
                    ArrayList<Name> list = (ArrayList<Name>)branch.get(factory);
                    if (list == null) {
                        list = new ArrayList<Name>();
                        list.addAll(factory.getNames());
                        Collections.sort(list, new Comparator<Name>(){

                            @Override
                            public int compare(Name o1, Name o2) {
                                String s1 = o1.toString();
                                String s2 = o2.toString();
                                return s1.compareTo(s2);
                            }
                        });
                        branch.put(factory, list);
                    }
                    return list;
                }
            }

            @Override
            public Object getChild(Object parent, int index) {
                if (parent == root) {
                    return root.get(index);
                }
                if (parent instanceof ProcessFactory) {
                    ProcessFactory factory = (ProcessFactory)parent;
                    return this.getChildren(factory).get(index);
                }
                return null;
            }

            @Override
            public int getChildCount(Object parent) {
                if (parent == root) {
                    return root.size();
                }
                if (parent instanceof ProcessFactory) {
                    ProcessFactory factory = (ProcessFactory)parent;
                    return this.getChildren(factory).size();
                }
                return 0;
            }

            @Override
            public boolean isLeaf(Object node) {
                if (node == root) {
                    return false;
                }
                if (node instanceof ProcessFactory) {
                    return false;
                }
                if (node instanceof Name) {
                    return true;
                }
                return true;
            }

            @Override
            public void valueForPathChanged(TreePath path, Object newValue) {
            }

            @Override
            public int getIndexOfChild(Object parent, Object child) {
                if (parent == root) {
                    return root.indexOf(child);
                }
                if (parent instanceof ProcessFactory) {
                    ProcessFactory factory = (ProcessFactory)parent;
                    return this.getChildren(factory).indexOf(child);
                }
                return 0;
            }

            @Override
            public void addTreeModelListener(TreeModelListener l) {
            }

            @Override
            public void removeTreeModelListener(TreeModelListener l) {
            }
        };
    }

    private ProcessFactory findProcessFactoryByTitle(String title) {
        for (ProcessFactory fac : this.processFactories) {
            if (!fac.getTitle().toString().equalsIgnoreCase(title)) continue;
            return fac;
        }
        return null;
    }

    private void updateProcessDesc(ProcessFactory factory, Name name) {
        if (name == null || factory == null) {
            return;
        }
        InternationalString title = factory.getTitle(name);
        InternationalString description = factory.getDescription(name);
        this.descLabel.setText(defaultDesc);
        this.selectedFactory = factory;
        this.selectedName = name;
        this.updateNavButtons();
        this.descLabel.setText("<html><b>" + title + "</b>" + description);
        this.updateNavButtons();
    }

    private void updateNavButtons() {
        this.getJWizard().getController().syncButtonsToPage();
    }
}

