/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.util.SoftValueHashMap;
import org.geotools.xml.SchemaIndex;
import org.geotools.xml.Schemas;

public class SchemaIndexImpl
implements SchemaIndex {
    XSDSchema[] schemas;
    HashMap elementIndex;
    HashMap attributeIndex;
    HashMap attributeGroupIndex;
    HashMap complexTypeIndex;
    HashMap simpleTypeIndex;
    SoftValueHashMap element2children = new SoftValueHashMap(1000);
    HashMap element2attributes = new HashMap();
    SchemaAdapter adapter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaIndexImpl(XSDSchema[] schemas) {
        this.schemas = new XSDSchema[schemas.length + 1];
        this.adapter = new SchemaAdapter();
        for (int i = 0; i < schemas.length; ++i) {
            this.schemas[i] = schemas[i];
            EList<Adapter> eList = this.schemas[i].eAdapters();
            synchronized (eList) {
                this.schemas[i].eAdapters().add(this.adapter);
                continue;
            }
        }
        this.schemas[schemas.length] = schemas[0].getSchemaForSchema();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        for (int i = 0; i < this.schemas.length; ++i) {
            EList<Adapter> eList = this.schemas[i].eAdapters();
            synchronized (eList) {
                this.schemas[i].eAdapters().remove(this.adapter);
                continue;
            }
        }
        this.schemas = null;
    }

    @Override
    public XSDSchema[] getSchemas() {
        return this.schemas;
    }

    public XSDImport[] getImports() {
        Collection imports = this.find(XSDImport.class);
        return imports.toArray(new XSDImport[imports.size()]);
    }

    public XSDInclude[] getIncludes() {
        Collection includes = this.find(XSDInclude.class);
        return includes.toArray(new XSDInclude[includes.size()]);
    }

    @Override
    public XSDElementDeclaration getElementDeclaration(QName qName) {
        return (XSDElementDeclaration)this.lookup(this.getElementIndex(), qName);
    }

    @Override
    public XSDAttributeDeclaration getAttributeDeclaration(QName qName) {
        return (XSDAttributeDeclaration)this.lookup(this.getAttributeIndex(), qName);
    }

    @Override
    public XSDAttributeGroupDefinition getAttributeGroupDefinition(QName qName) {
        return (XSDAttributeGroupDefinition)this.lookup(this.getAttributeGroupIndex(), qName);
    }

    @Override
    public XSDComplexTypeDefinition getComplexTypeDefinition(QName qName) {
        return (XSDComplexTypeDefinition)this.lookup(this.getComplexTypeIndex(), qName);
    }

    @Override
    public XSDSimpleTypeDefinition getSimpleTypeDefinition(QName qName) {
        return (XSDSimpleTypeDefinition)this.lookup(this.getSimpleTypeIndex(), qName);
    }

    @Override
    public XSDTypeDefinition getTypeDefinition(QName qName) {
        XSDTypeDefinition type = this.getComplexTypeDefinition(qName);
        if (type == null) {
            type = this.getSimpleTypeDefinition(qName);
        }
        return type;
    }

    protected XSDNamedComponent lookup(Map index, QName qName) {
        XSDNamedComponent component = (XSDNamedComponent)index.get(qName);
        if (component != null) {
            return component;
        }
        if ("*".equals(qName.getNamespaceURI())) {
            ArrayList matches = new ArrayList();
            for (Map.Entry entry : index.entrySet()) {
                QName name = (QName)entry.getKey();
                if (!name.getLocalPart().equals(qName.getLocalPart())) continue;
                matches.add(entry.getValue());
            }
            if (matches.size() == 1) {
                return (XSDNamedComponent)matches.get(0);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OrderedMap children(XSDElementDeclaration parent) {
        OrderedMap children = (OrderedMap)this.element2children.get(parent);
        if (children == null) {
            SchemaIndexImpl schemaIndexImpl = this;
            synchronized (schemaIndexImpl) {
                if (children == null) {
                    children = new ListOrderedMap();
                    for (XSDParticle particle : Schemas.getChildElementParticles(parent.getType(), true)) {
                        XSDElementDeclaration child = (XSDElementDeclaration)particle.getContent();
                        if (child.isElementDeclarationReference()) {
                            child = child.getResolvedElementDeclaration();
                        }
                        QName childName = null;
                        childName = child.getTargetNamespace() != null ? new QName(child.getTargetNamespace(), child.getName()) : (parent.getTargetNamespace() != null ? new QName(parent.getTargetNamespace(), child.getName()) : (parent.getType().getTargetNamespace() != null ? new QName(parent.getType().getTargetNamespace(), child.getName()) : new QName(null, child.getName())));
                        children.put(childName, particle);
                    }
                    this.element2children.put(parent, children);
                }
            }
        }
        return children;
    }

    @Override
    public XSDElementDeclaration getChildElement(XSDElementDeclaration parent, QName childName) {
        OrderedMap children = this.children(parent);
        XSDParticle particle = (XSDParticle)children.get(childName);
        if (particle != null) {
            XSDElementDeclaration child = (XSDElementDeclaration)particle.getContent();
            if (child.isElementDeclarationReference()) {
                child = child.getResolvedElementDeclaration();
            }
            return child;
        }
        if ("*".equals(childName.getNamespaceURI())) {
            ArrayList matches = new ArrayList();
            for (Map.Entry entry : children.entrySet()) {
                QName name = (QName)entry.getKey();
                if (!name.getLocalPart().equals(childName.getLocalPart())) continue;
                matches.add(entry.getValue());
            }
            if (matches.size() == 1) {
                particle = (XSDParticle)matches.get(0);
                XSDElementDeclaration child = (XSDElementDeclaration)particle.getContent();
                if (child.isElementDeclarationReference()) {
                    child = child.getResolvedElementDeclaration();
                }
                return child;
            }
        }
        return null;
    }

    @Override
    public List getChildElementParticles(XSDElementDeclaration parent) {
        return new ArrayList(this.children(parent).values());
    }

    @Override
    public List getAttributes(XSDElementDeclaration element) {
        List attributes = (List)this.element2attributes.get(element);
        if (attributes == null) {
            attributes = Schemas.getAttributeDeclarations(element);
            this.element2attributes.put(element, attributes);
        }
        return Collections.unmodifiableList(attributes);
    }

    protected Collection find(Class c) {
        ArrayList found = new ArrayList();
        for (int i = 0; i < this.schemas.length; ++i) {
            XSDSchema schema = this.schemas[i];
            EList<XSDSchemaContent> content = schema.getContents();
            for (Object e : content) {
                if (!c.isAssignableFrom(e.getClass())) continue;
                found.add(e);
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap getElementIndex() {
        if (this.elementIndex == null) {
            SchemaIndexImpl schemaIndexImpl = this;
            synchronized (schemaIndexImpl) {
                if (this.elementIndex == null) {
                    this.buildElementIndex();
                }
            }
        }
        return this.elementIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap getAttributeIndex() {
        if (this.attributeIndex == null) {
            SchemaIndexImpl schemaIndexImpl = this;
            synchronized (schemaIndexImpl) {
                if (this.attributeIndex == null) {
                    this.buildAttriubuteIndex();
                }
            }
        }
        return this.attributeIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap getAttributeGroupIndex() {
        if (this.attributeGroupIndex == null) {
            SchemaIndexImpl schemaIndexImpl = this;
            synchronized (schemaIndexImpl) {
                if (this.attributeGroupIndex == null) {
                    this.buildAttributeGroupIndex();
                }
            }
        }
        return this.attributeGroupIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap getComplexTypeIndex() {
        if (this.complexTypeIndex == null) {
            SchemaIndexImpl schemaIndexImpl = this;
            synchronized (schemaIndexImpl) {
                if (this.complexTypeIndex == null) {
                    this.buildComplexTypeIndex();
                }
            }
        }
        return this.complexTypeIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap getSimpleTypeIndex() {
        if (this.simpleTypeIndex == null) {
            SchemaIndexImpl schemaIndexImpl = this;
            synchronized (schemaIndexImpl) {
                if (this.simpleTypeIndex == null) {
                    this.buildSimpleTypeIndex();
                }
            }
        }
        return this.simpleTypeIndex;
    }

    protected void buildElementIndex() {
        this.elementIndex = new HashMap();
        for (int i = 0; i < this.schemas.length; ++i) {
            XSDSchema schema = this.schemas[i];
            for (XSDElementDeclaration element : schema.getElementDeclarations()) {
                QName qName = new QName(element.getTargetNamespace(), element.getName());
                this.elementIndex.put(qName, element);
            }
        }
    }

    protected void buildAttriubuteIndex() {
        this.attributeIndex = new HashMap();
        for (int i = 0; i < this.schemas.length; ++i) {
            XSDSchema schema = this.schemas[i];
            for (XSDAttributeDeclaration attribute : schema.getAttributeDeclarations()) {
                QName qName = new QName(attribute.getTargetNamespace(), attribute.getName());
                this.attributeIndex.put(qName, attribute);
            }
        }
    }

    protected void buildAttributeGroupIndex() {
        this.attributeGroupIndex = new HashMap();
        for (int i = 0; i < this.schemas.length; ++i) {
            XSDSchema schema = this.schemas[i];
            for (XSDAttributeGroupDefinition group : schema.getAttributeGroupDefinitions()) {
                QName qName = new QName(group.getTargetNamespace(), group.getName());
                this.attributeGroupIndex.put(qName, group);
            }
        }
    }

    protected void buildComplexTypeIndex() {
        this.complexTypeIndex = new HashMap();
        for (int i = 0; i < this.schemas.length; ++i) {
            XSDSchema schema = this.schemas[i];
            for (XSDTypeDefinition type : schema.getTypeDefinitions()) {
                if (!(type instanceof XSDComplexTypeDefinition)) continue;
                QName qName = new QName(type.getTargetNamespace(), type.getName());
                this.complexTypeIndex.put(qName, type);
            }
        }
    }

    protected void buildSimpleTypeIndex() {
        this.simpleTypeIndex = new HashMap();
        for (int i = 0; i < this.schemas.length; ++i) {
            XSDSchema schema = this.schemas[i];
            for (XSDTypeDefinition type : schema.getTypeDefinitions()) {
                if (!(type instanceof XSDSimpleTypeDefinition)) continue;
                QName qName = new QName(type.getTargetNamespace(), type.getName());
                this.simpleTypeIndex.put(qName, type);
            }
        }
    }

    class SchemaAdapter
    implements Adapter {
        Notifier target;
        Notification last;

        SchemaAdapter() {
        }

        @Override
        public Notifier getTarget() {
            return this.target;
        }

        @Override
        public void setTarget(Notifier target) {
            this.target = target;
        }

        @Override
        public boolean isAdapterForType(Object object) {
            return object instanceof XSDSchema;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyChanged(Notification notification) {
            if (notification.getEventType() == 3) {
                switch (notification.getFeatureID(XSDSchema.class)) {
                    case 15: {
                        SchemaIndexImpl schemaIndexImpl = SchemaIndexImpl.this;
                        synchronized (schemaIndexImpl) {
                            SchemaIndexImpl.this.attributeIndex = null;
                            break;
                        }
                    }
                    case 14: {
                        SchemaIndexImpl schemaIndexImpl = SchemaIndexImpl.this;
                        synchronized (schemaIndexImpl) {
                            SchemaIndexImpl.this.elementIndex = null;
                            break;
                        }
                    }
                    case 17: {
                        SchemaIndexImpl schemaIndexImpl = SchemaIndexImpl.this;
                        synchronized (schemaIndexImpl) {
                            SchemaIndexImpl.this.complexTypeIndex = null;
                            SchemaIndexImpl.this.simpleTypeIndex = null;
                            break;
                        }
                    }
                    case 16: {
                        SchemaIndexImpl schemaIndexImpl = SchemaIndexImpl.this;
                        synchronized (schemaIndexImpl) {
                            SchemaIndexImpl.this.attributeGroupIndex = null;
                            break;
                        }
                    }
                }
            }
        }
    }
}

