/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.footprint;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.geotools.coverage.grid.io.footprint.FootprintLoaderSpi;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryRegistry;

public final class FootprintLoaderFinder {
    private static FactoryRegistry registry;

    private FootprintLoaderFinder() {
    }

    public static synchronized Set<FootprintLoaderSpi> getAvailableLoaders() {
        FootprintLoaderFinder.scanForPlugins();
        Iterator<FootprintLoaderSpi> it = FootprintLoaderFinder.getServiceRegistry().getServiceProviders(FootprintLoaderSpi.class, true);
        HashSet<FootprintLoaderSpi> loaders = new HashSet<FootprintLoaderSpi>();
        while (it.hasNext()) {
            loaders.add(it.next());
        }
        return Collections.unmodifiableSet(loaders);
    }

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(FootprintLoaderFinder.class));
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(FootprintLoaderSpi.class));
        }
        return registry;
    }

    public static synchronized void scanForPlugins() {
        FootprintLoaderFinder.getServiceRegistry().scanForPlugins();
    }
}

