/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.filter.BinaryComparisonAbstract;
import org.geotools.filter.Filters;
import org.geotools.filter.IllegalFilterException;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BinarySpatialOperator;

public abstract class GeometryFilterImpl
extends BinaryComparisonAbstract
implements BinarySpatialOperator {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.filter");
    protected MultiValuedFilter.MatchAction matchAction;

    @Deprecated
    protected GeometryFilterImpl() throws IllegalFilterException {
    }

    protected GeometryFilterImpl(MultiValuedFilter.MatchAction matchAction) {
        this.matchAction = matchAction;
    }

    protected GeometryFilterImpl(Expression e1, Expression e2, MultiValuedFilter.MatchAction matchAction) {
        super(e1, e2);
        this.matchAction = matchAction;
    }

    protected GeometryFilterImpl(FilterFactory factory) {
        this(MultiValuedFilter.MatchAction.ANY);
    }

    protected GeometryFilterImpl(Expression e1, Expression e2) {
        this(e1, e2, MultiValuedFilter.MatchAction.ANY);
    }

    protected static Object getGeometries(Expression expr, Object feature) {
        Object o = expr.evaluate(feature);
        if (o instanceof Collection) {
            ArrayList<Geometry> list = new ArrayList<Geometry>();
            for (Object item : (Collection)o) {
                Geometry geometry = Converters.convert(item, Geometry.class);
                if (geometry == null) continue;
                list.add(geometry);
            }
            return list.size() > 0 ? list : null;
        }
        return Converters.convert(o, Geometry.class);
    }

    public String toString() {
        String operator = null;
        short filterType = Filters.getFilterType(this);
        if (filterType == 5) {
            operator = " equals ";
        } else if (filterType == 6) {
            operator = " disjoint ";
        } else if (filterType == 7) {
            operator = " intersects ";
        } else if (filterType == 8) {
            operator = " touches ";
        } else if (filterType == 9) {
            operator = " crosses ";
        } else if (filterType == 10) {
            operator = " within ";
        } else if (filterType == 11) {
            operator = " contains ";
        } else if (filterType == 12) {
            operator = " overlaps ";
        } else if (filterType == 13) {
            operator = " beyond ";
        } else if (filterType == 4) {
            operator = " bbox ";
        }
        Expression leftGeometry = this.getExpression1();
        Expression rightGeometry = this.getExpression2();
        if (this.expression1 == null && rightGeometry == null) {
            return "[ null" + operator + "null" + " ]";
        }
        if (leftGeometry == null) {
            return "[ null" + operator + rightGeometry.toString() + " ]";
        }
        if (rightGeometry == null) {
            return "[ " + leftGeometry.toString() + operator + "null" + " ]";
        }
        return "[ " + leftGeometry.toString() + operator + rightGeometry.toString() + " ]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof GeometryFilterImpl) {
            GeometryFilterImpl geomFilter = (GeometryFilterImpl)obj;
            boolean isEqual = true;
            boolean bl = isEqual = Filters.getFilterType(geomFilter) == Filters.getFilterType(this);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("filter type match:" + isEqual + "; in:" + Filters.getFilterType(geomFilter) + "; out:" + Filters.getFilterType(this));
            }
            boolean bl2 = geomFilter.expression1 != null ? isEqual && geomFilter.expression1.equals(this.expression1) : (isEqual = isEqual && this.expression1 == null);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("left geom match:" + isEqual + "; in:" + geomFilter.expression1 + "; out:" + this.expression1);
            }
            boolean bl3 = geomFilter.expression2 != null ? isEqual && geomFilter.expression2.equals(this.expression2) : (isEqual = isEqual && this.expression2 == null);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("right geom match:" + isEqual + "; in:" + geomFilter.expression2 + "; out:" + this.expression2);
            }
            return isEqual;
        }
        return false;
    }

    public int hashCode() {
        Expression leftGeometry = this.getExpression1();
        Expression rightGeometry = this.getExpression2();
        int result = 17;
        short filterType = Filters.getFilterType(this);
        result = 37 * result + filterType;
        result = 37 * result + (leftGeometry == null ? 0 : leftGeometry.hashCode());
        result = 37 * result + (rightGeometry == null ? 0 : rightGeometry.hashCode());
        return result;
    }

    @Override
    public MultiValuedFilter.MatchAction getMatchAction() {
        return this.matchAction;
    }

    @Override
    public final boolean evaluate(Object feature) {
        Object object1 = GeometryFilterImpl.getGeometries(this.getExpression1(), feature);
        Object object2 = GeometryFilterImpl.getGeometries(this.getExpression2(), feature);
        if (object1 == null || object2 == null) {
            return false;
        }
        if (!(object1 instanceof Collection) && !(object2 instanceof Collection)) {
            return this.evaluateInternal((Geometry)object1, (Geometry)object2);
        }
        List<Geometry> leftValues = object1 instanceof Collection ? (List<Geometry>)object1 : Collections.singletonList((Geometry)object1);
        List<Geometry> rightValues = object2 instanceof Collection ? (List<Geometry>)object2 : Collections.singletonList((Geometry)object2);
        int count = 0;
        for (Geometry leftValue : leftValues) {
            for (Geometry rightValue : rightValues) {
                boolean temp = this.evaluateInternal(leftValue, rightValue);
                if (temp) {
                    ++count;
                }
                switch (this.matchAction) {
                    case ONE: {
                        if (count <= 1) break;
                        return false;
                    }
                    case ALL: {
                        if (temp) break;
                        return false;
                    }
                    case ANY: {
                        if (!temp) break;
                        return true;
                    }
                }
            }
        }
        switch (this.matchAction) {
            case ONE: {
                return count == 1;
            }
            case ALL: {
                return true;
            }
            case ANY: {
                return false;
            }
        }
        return false;
    }

    protected abstract boolean evaluateInternal(Geometry var1, Geometry var2);
}

