/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.impl;

import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDSchemaContent;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.InstanceComponent;
import org.geotools.xml.Node;
import org.geotools.xml.ParserDelegate;
import org.geotools.xml.impl.DocumentHandler;
import org.geotools.xml.impl.ElementHandler;
import org.geotools.xml.impl.ElementImpl;
import org.geotools.xml.impl.Handler;
import org.geotools.xml.impl.NodeImpl;
import org.picocontainer.MutablePicoContainer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DelegatingHandler
implements DocumentHandler,
ElementHandler {
    ParserDelegate delegate;
    Handler parent;
    QName elementName;
    NodeImpl parseTree;

    DelegatingHandler(ParserDelegate delegate, QName elementName, Handler parent) {
        this.delegate = delegate;
        this.parent = parent;
        this.elementName = elementName;
        XSDElementDeclaration e = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        e.setTargetNamespace(elementName.getNamespaceURI());
        e.setName(elementName.getLocalPart());
        ElementImpl instance = new ElementImpl(e);
        instance.setName(elementName.getLocalPart());
        instance.setNamespace(elementName.getNamespaceURI());
        this.parseTree = new NodeImpl(instance);
    }

    @Override
    public void setContext(MutablePicoContainer context) {
    }

    @Override
    public MutablePicoContainer getContext() {
        return null;
    }

    @Override
    public XSDElementDeclaration getElementDeclaration() {
        return ((ElementInstance)this.parseTree.getComponent()).getElementDeclaration();
    }

    @Override
    public Handler getParentHandler() {
        return this.parent;
    }

    @Override
    public Handler createChildHandler(QName name) {
        return new DelegatingHandler(this.delegate, name, this);
    }

    @Override
    public void startChildHandler(Handler child) {
    }

    @Override
    public void endChildHandler(Handler child) {
    }

    @Override
    public InstanceComponent getComponent() {
        return null;
    }

    @Override
    public Node getParseNode() {
        return this.parseTree;
    }

    @Override
    public XSDSchemaContent getSchemaContent() {
        return null;
    }

    @Override
    public void startDocument() throws SAXException {
        this.delegate.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.delegate.endDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.delegate.startPrefixMapping(prefix, uri);
    }

    @Override
    public void startElement(QName name, Attributes attributes) throws SAXException {
        if (!(this.parent instanceof DelegatingHandler)) {
            this.parent.startChildHandler(this);
        }
        this.delegate.startElement(name.getNamespaceURI(), name.getLocalPart(), this.qname(name), attributes);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.delegate.characters(ch, start, length);
    }

    @Override
    public void endElement(QName name) throws SAXException {
        this.delegate.endElement(name.getNamespaceURI(), name.getLocalPart(), this.qname(name));
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.delegate.endPrefixMapping(prefix);
    }

    String qname(QName name) {
        return name.getNamespaceURI() != null ? name.getPrefix() + ":" + name.getLocalPart() : name.getLocalPart();
    }
}

