/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;

public class MultiCurveTypeBinding
extends AbstractComplexBinding {
    protected GeometryFactory gf;

    public MultiCurveTypeBinding(GeometryFactory gf) {
        this.gf = gf;
    }

    @Override
    public QName getTarget() {
        return GML.MultiCurveType;
    }

    @Override
    public Class getType() {
        return MultiLineString.class;
    }

    @Override
    public int getExecutionMode() {
        return 1;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        List curves = node.getChildValues(LineString.class);
        if (node.hasChild(MultiLineString[].class)) {
            MultiLineString[] lines;
            for (MultiLineString mline : lines = (MultiLineString[])node.getChildValue(MultiLineString[].class)) {
                if (mline.getNumGeometries() != 1) {
                    throw new IllegalArgumentException("Unable to handle curve member with multiple segments");
                }
                curves.add(mline.getGeometryN(0));
            }
        }
        return this.gf.createMultiLineString(curves.toArray(new LineString[curves.size()]));
    }

    @Override
    public Object getProperty(Object object, QName name) throws Exception {
        if ("curveMember".equals(name.getLocalPart())) {
            MultiLineString multiCurve = (MultiLineString)object;
            LineString[] members = new LineString[multiCurve.getNumGeometries()];
            for (int i = 0; i < members.length; ++i) {
                members[i] = (LineString)multiCurve.getGeometryN(i);
            }
            GML3EncodingUtils.setChildIDs(multiCurve);
            return members;
        }
        super.getProperty(object, name);
        return null;
    }
}

