/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.List;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.function.StaticGeometry;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;

public class InFunction
extends FunctionExpressionImpl {
    public static FunctionName NAME = InFunction.functionName("in", "result:Boolean", "candidate:Object:1,1", "v:Object:1,");

    public InFunction() {
        super(NAME);
    }

    @Override
    public String getName() {
        return NAME.getName();
    }

    public int getArgCount() {
        return NAME.getArgumentCount();
    }

    @Override
    public Object evaluate(Object feature) {
        Object candidate = this.getExpression(0).evaluate(feature);
        boolean result = false;
        List<Expression> valuesToTest = this.getParameters().subList(1, this.getParameters().size());
        for (Expression expression : valuesToTest) {
            Object value = expression.evaluate(feature);
            if (candidate == null) {
                result = StaticGeometry.isNull(value);
            } else {
                boolean bl = result = result || StaticGeometry.equalTo(candidate, value);
            }
            if (!result) continue;
            break;
        }
        return result;
    }
}

