/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.File;
import java.net.URL;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDSchemaLocationResolver;
import org.geotools.xml.XSD;

public class SchemaLocationResolver
implements XSDSchemaLocationResolver {
    protected XSD xsd;
    protected String[] lookupDirectories;

    public SchemaLocationResolver(XSD xsd) {
        this(xsd, new String[0]);
    }

    public SchemaLocationResolver(XSD xsd, String ... lookupDirectories) {
        this.xsd = xsd;
        this.lookupDirectories = lookupDirectories;
    }

    public boolean canHandle(XSDSchema schema, String uri, String location) {
        if (this.xsd.getNamespaceURI().equals(uri)) {
            URL xsdLocation = this.resolveLocationToResource(location);
            return xsdLocation != null;
        }
        return false;
    }

    private URL resolveLocationToResource(String location) {
        URL url = this.xsd.getClass().getResource(location);
        if (url == null) {
            String fileName = new File(location).getName();
            url = this.xsd.getClass().getResource(fileName);
        }
        if (url == null && this.lookupDirectories != null) {
            for (String lookup : this.lookupDirectories) {
                if (lookup.endsWith("/")) {
                    lookup = lookup.substring(0, lookup.length() - 1);
                }
                url = this.xsd.getClass().getResource(lookup + "/" + location);
            }
        }
        return url;
    }

    @Override
    public String resolveSchemaLocation(XSDSchema schema, String uri, String location) {
        if (location == null) {
            return null;
        }
        if ((uri == null || "".equals(uri)) && schema != null) {
            uri = schema.getTargetNamespace();
        }
        if (this.canHandle(schema, uri, location)) {
            return this.resolveLocationToResource(location).toString();
        }
        return null;
    }

    public String toString() {
        return this.xsd.toString();
    }
}

