/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.lang.reflect.Array;
import javax.media.jai.Interpolation;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.Interpolator2D;
import org.geotools.coverage.processing.Operation2D;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.resources.image.ImageUtilities;
import org.opengis.coverage.Coverage;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;

public class Interpolate
extends Operation2D {
    private static final long serialVersionUID = 6742127682733620661L;
    public static final ParameterDescriptor TYPE = new DefaultParameterDescriptor<String>(Citations.OGC, "Type", Object.class, null, "NearestNeighbor", null, null, null, true);

    public Interpolate() {
        super(new DefaultParameterDescriptorGroup(Citations.OGC, "Interpolate", new ParameterDescriptor[]{SOURCE_0, TYPE}));
    }

    @Override
    public Coverage doOperation(ParameterValueGroup parameters, Hints hints) {
        Interpolation[] interpolations;
        GridCoverage2D source = (GridCoverage2D)parameters.parameter("Source").getValue();
        Object type = parameters.parameter("Type").getValue();
        if (type.getClass().isArray()) {
            interpolations = new Interpolation[Array.getLength(type)];
            for (int i = 0; i < interpolations.length; ++i) {
                interpolations[i] = ImageUtilities.toInterpolation(Array.get(type, i));
            }
        } else {
            interpolations = new Interpolation[]{ImageUtilities.toInterpolation(type)};
        }
        return Interpolator2D.create(source, interpolations);
    }
}

