/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContent;
import org.geotools.swing.MapPane;
import org.geotools.swing.control.JMapStatusBar;
import org.geotools.swing.control.StatusBarItem;
import org.geotools.swing.event.MapPaneAdapter;
import org.geotools.swing.event.MapPaneEvent;
import org.geotools.swing.locale.LocaleUtils;
import org.geotools.swing.menu.JCRSPopupMenu;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JCRSStatusBarItem
extends StatusBarItem {
    private static final String COMPONENT_NAME = LocaleUtils.getValue("StatusBar", "CRSItemName");
    private static final String NO_CRS = LocaleUtils.getValue("StatusBar", "CRSUndefined");
    private static final String TOOL_TIP = LocaleUtils.getValue("StatusBar", "CRSTooltip");
    private final JButton btn;

    public JCRSStatusBarItem(MapPane mapPane) {
        super(COMPONENT_NAME);
        if (mapPane == null) {
            throw new IllegalArgumentException("mapPane must not be null");
        }
        this.btn = new JButton(NO_CRS);
        this.btn.setBorder(BorderFactory.createEmptyBorder());
        this.btn.setFont(JMapStatusBar.DEFAULT_FONT);
        this.btn.setToolTipText(TOOL_TIP);
        this.add(this.btn);
        CoordinateReferenceSystem crs = null;
        MapContent mapContent = mapPane.getMapContent();
        if (mapContent != null) {
            crs = mapContent.getCoordinateReferenceSystem();
        }
        this.displayCRS(crs);
        mapPane.addMapPaneListener(new MapPaneAdapter(){

            @Override
            public void onDisplayAreaChanged(MapPaneEvent ev) {
                ReferencedEnvelope env = (ReferencedEnvelope)ev.getData();
                JCRSStatusBarItem.this.displayCRS(env.getCoordinateReferenceSystem());
            }
        });
        final JCRSPopupMenu menu = new JCRSPopupMenu(mapPane);
        this.btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                menu.show(JCRSStatusBarItem.this.btn, 0, 0);
            }
        });
    }

    private void displayCRS(CoordinateReferenceSystem crs) {
        String crsName;
        String name = NO_CRS;
        if (crs != null && (crsName = crs.getName().toString()) != null && crsName.trim().length() > 0) {
            name = crsName;
        }
        this.btn.setText(name);
    }
}

