/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.tool;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.swing.event.MapMouseEvent;
import org.geotools.swing.locale.LocaleUtils;
import org.geotools.swing.tool.AbstractZoomTool;

public class ZoomInTool
extends AbstractZoomTool {
    public static final String TOOL_NAME = LocaleUtils.getValue("CursorTool", "ZoomIn");
    public static final String TOOL_TIP = LocaleUtils.getValue("CursorTool", "ZoomInTooltip");
    public static final String CURSOR_IMAGE = "/org/geotools/swing/icons/mActionZoomIn.png";
    public static final Point CURSOR_HOTSPOT = new Point(14, 9);
    public static final String ICON_IMAGE = "/org/geotools/swing/icons/mActionZoomIn.png";
    private Cursor cursor;
    private final Point startPosDevice;
    private final Point2D startPosWorld;
    private boolean dragged;

    public ZoomInTool() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        ImageIcon imgIcon = new ImageIcon(this.getClass().getResource("/org/geotools/swing/icons/mActionZoomIn.png"));
        this.cursor = tk.createCustomCursor(imgIcon.getImage(), CURSOR_HOTSPOT, TOOL_NAME);
        this.startPosDevice = new Point();
        this.startPosWorld = new DirectPosition2D();
        this.dragged = false;
    }

    @Override
    public void onMouseClicked(MapMouseEvent e) {
        Rectangle paneArea = ((JComponent)((Object)this.getMapPane())).getVisibleRect();
        DirectPosition2D mapPos = e.getWorldPos();
        double scale = this.getMapPane().getWorldToScreenTransform().getScaleX();
        double newScale = scale * this.zoom;
        DirectPosition2D corner = new DirectPosition2D(mapPos.getX() - 0.5 * paneArea.getWidth() / newScale, mapPos.getY() + 0.5 * paneArea.getHeight() / newScale);
        Envelope2D newMapArea = new Envelope2D();
        newMapArea.setFrameFromCenter(mapPos, corner);
        this.getMapPane().setDisplayArea(newMapArea);
    }

    @Override
    public void onMousePressed(MapMouseEvent ev) {
        this.startPosDevice.setLocation(ev.getPoint());
        this.startPosWorld.setLocation(ev.getWorldPos());
    }

    @Override
    public void onMouseDragged(MapMouseEvent ev) {
        this.dragged = true;
    }

    @Override
    public void onMouseReleased(MapMouseEvent ev) {
        if (this.dragged && !ev.getPoint().equals(this.startPosDevice)) {
            Envelope2D env = new Envelope2D();
            env.setFrameFromDiagonal(this.startPosWorld, ev.getWorldPos());
            this.dragged = false;
            this.getMapPane().setDisplayArea(env);
        }
    }

    @Override
    public Cursor getCursor() {
        return this.cursor;
    }

    @Override
    public boolean drawDragBox() {
        return true;
    }
}

