/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.handlers.xsi;

import org.geotools.xml.XSIElementHandler;
import org.geotools.xml.handlers.xsi.SchemaHandler;
import org.geotools.xml.handlers.xsi.SimpleTypeHandler;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.SimpleType;
import org.geotools.xml.schema.impl.AttributeGT;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;

public class AttributeHandler
extends XSIElementHandler {
    public static final String LOCALNAME = "attribute";
    public static final int OPTIONAL = 0;
    public static final int PROHIBITED = 1;
    public static final int REQUIRED = 2;
    private static int offset = 0;
    private String id;
    private String name;
    private String type;
    private String ref;
    private String def;
    private String fixed;
    private int use;
    private SimpleTypeHandler simpleType;
    private int hashCodeOffset = AttributeHandler.getOffset();
    private Attribute cache = null;

    private static int getOffset() {
        return offset++;
    }

    @Override
    public int hashCode() {
        return LOCALNAME.hashCode() * (this.id == null ? 1 : this.id.hashCode()) * (this.type == null ? 1 : this.type.hashCode()) * (this.name == null ? 1 : this.name.hashCode()) + this.hashCodeOffset;
    }

    @Override
    public XSIElementHandler getHandler(String namespaceURI, String localName) throws SAXException {
        if ("http://www.w3.org/2001/XMLSchema".equalsIgnoreCase(namespaceURI) && "simpleType".equalsIgnoreCase(localName)) {
            SimpleTypeHandler sth = new SimpleTypeHandler();
            if (this.simpleType != null) {
                throw new SAXNotRecognizedException("Extension may only have one 'simpleType' or 'complexType' declaration.");
            }
            this.simpleType = sth;
            return sth;
        }
        return null;
    }

    @Override
    public void startElement(String namespaceURI, String localName, Attributes atts) {
        String use1;
        String type1;
        String ref1;
        String name1;
        this.id = atts.getValue("", "id");
        if (this.id == null) {
            this.id = atts.getValue(namespaceURI, "id");
        }
        if ((name1 = atts.getValue("", "name")) == null) {
            name1 = atts.getValue(namespaceURI, "name");
        }
        if ((ref1 = atts.getValue("", "ref")) == null) {
            ref1 = atts.getValue(namespaceURI, "ref");
        }
        if ((type1 = atts.getValue("", "type")) == null) {
            type1 = atts.getValue(namespaceURI, "type");
        }
        this.name = name1;
        this.type = type1;
        this.ref = ref1;
        this.def = atts.getValue("", "default");
        if (this.def == null) {
            this.def = atts.getValue(namespaceURI, "default");
        }
        this.fixed = atts.getValue("", "fixed");
        if (this.fixed == null) {
            this.fixed = atts.getValue(namespaceURI, "fixed");
        }
        if ((use1 = atts.getValue("", "use")) == null) {
            use1 = atts.getValue(namespaceURI, "use");
        }
        this.use = AttributeHandler.findUse(use1);
    }

    @Override
    public String getLocalName() {
        return LOCALNAME;
    }

    public static int findUse(String use) {
        if ("optional".equalsIgnoreCase(use)) {
            return 0;
        }
        if ("prohibited".equalsIgnoreCase(use)) {
            return 1;
        }
        if ("required".equalsIgnoreCase(use)) {
            return 2;
        }
        return -1;
    }

    public static String writeUse(int use) {
        switch (use) {
            case 0: {
                return "optional";
            }
            case 1: {
                return "prohibited";
            }
            case 2: {
                return "required";
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    protected Attribute compress(SchemaHandler parent) throws SAXException {
        if (this.cache != null) {
            return this.cache;
        }
        SimpleType st = null;
        String name1 = this.name;
        String def1 = this.def;
        String fixed1 = this.fixed;
        int use1 = this.use;
        if (this.simpleType != null) {
            st = this.simpleType.compress(parent);
        } else if (this.ref != null && !"".equalsIgnoreCase(this.ref)) {
            Attribute refA = parent.lookUpAttribute(this.ref);
            if (refA == null) {
                throw new SAXException("Attribute '" + this.ref + "' was refered and not found");
            }
            st = refA.getSimpleType();
            name1 = refA.getName();
            use1 |= refA.getUse();
            if (def1 == null || "".equalsIgnoreCase(def1)) {
                def1 = refA.getDefault();
            }
            if (fixed1 == null || "".equalsIgnoreCase(fixed1)) {
                fixed1 = refA.getFixed();
            }
        } else if (this.type != null && !"".equalsIgnoreCase(this.type)) {
            st = parent.lookUpSimpleType(this.type);
        }
        this.cache = new AttributeGT(this.id, name1, parent.getTargetNamespace(), st, use1, def1, fixed1, false);
        this.ref = null;
        this.type = null;
        this.id = null;
        return this.cache;
    }

    @Override
    public int getHandlerType() {
        return 0;
    }

    @Override
    public void endElement(String namespaceURI, String localName) {
    }
}

