/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.google;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.BaseAutoLogin;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import gr.cite.google.GoogleOAuth;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class GoogleAutoLogin
extends BaseAutoLogin {
    private static final Log log = LogFactoryUtil.getLog(GoogleOAuth.class);

    protected String[] doLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        boolean googleAuthEnabled = PrefsPropsUtil.getBoolean((long)companyId, (String)"google.auth.enabled", (boolean)true);
        log.debug((Object)("Is google enabled: " + googleAuthEnabled));
        if (!googleAuthEnabled) {
            return null;
        }
        User user = this.getUser(request, companyId);
        if (user == null) {
            return null;
        }
        String[] credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
        return credentials;
    }

    protected User getUser(HttpServletRequest request, long companyId) throws PortalException, SystemException {
        HttpSession session = request.getSession();
        String emailAddress = GetterUtil.getString((Object)session.getAttribute("userEmailAdressGoogle"));
        session.removeAttribute("userEmailAdressGoogle");
        log.debug((Object)("User's mail form session: " + emailAddress));
        if (Validator.isNull((String)emailAddress)) {
            return null;
        }
        User user = UserLocalServiceUtil.getUserByEmailAddress((long)companyId, (String)emailAddress);
        return user;
    }

    public static Log getLog() {
        return log;
    }
}

